/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.indexer;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.client.indexer.tocmaker.TocMaker;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndex;

public class IndexerRepositoryClient
extends AbstractRepositoryClient {
    private TocMaker indexComputor = new TocMaker();

    public IndexerRepositoryClient() {
        IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Indexer] Ready");
    }

    public void makeToc() {
        final RepositoryAdapter repositoryAdapter = this.repositoryObjectHandler.getRepositoryAdapter();
        if (repositoryAdapter != null) {
            repositoryAdapter.execute(new IntentCommand(){

                public void execute() {
                    IntentIndex index = new IndexQuery(repositoryAdapter).getOrCreateIntentIndex();
                    IntentDocument document = new IntentDocumentQuery(repositoryAdapter).getOrCreateIntentDocument();
                    IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Indexer] Indexing " + document.getChapters().size() + "chapters");
                    try {
                        repositoryAdapter.openSaveContext();
                        IndexerRepositoryClient.this.indexComputor.computeIndex(index, document);
                        repositoryAdapter.setSendSessionWarningBeforeSaving((Collection)Lists.newArrayList((Object[])new String[]{"/INTENT/"}));
                        repositoryAdapter.save();
                    }
                    catch (SaveException e) {
                        IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Indexer failed to save changes", (Throwable)e);
                    }
                    catch (ReadOnlyException e) {
                        IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Indexer failed to save changes", (Throwable)e);
                    }
                    repositoryAdapter.closeContext();
                    IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Indexer] Index saved");
                }
            });
        }
    }

    protected Job createNotificationJob(RepositoryChangeNotification notification) {
        Job job = new Job("Indexing"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus res = Status.OK_STATUS;
                IndexerRepositoryClient.this.makeToc();
                return res;
            }
        };
        job.setSystem(true);
        return job;
    }
}

