/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.repository.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryRegistry;

public class RepositoryRegistryImpl
implements RepositoryRegistry {
    private static final String REPOSITORY_CREATOR_CLASS_TAG = "repositoryCreatorClass";
    private static final String REPOSITORY_STRUCTURER_CLASS_TAG = "repositoryStructurerClass";
    private static final String REPOSITORY_EXTENSION_POINT = "org.eclipse.mylyn.docs.intent.collab.repository.extension";
    private Map<String, IConfigurationElement> repositoryExtensionsByName;

    private void initializeRegistry() {
        if (this.repositoryExtensionsByName == null) {
            IConfigurationElement[] elements;
            this.repositoryExtensionsByName = new HashMap<String, IConfigurationElement>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(REPOSITORY_EXTENSION_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String name = element.getAttribute("id");
                this.repositoryExtensionsByName.put(name, element);
                ++n2;
            }
        }
    }

    public synchronized RepositoryCreator getRepositoryCreator(String repositoryType) throws CoreException {
        IConfigurationElement element;
        if (this.repositoryExtensionsByName == null) {
            this.initializeRegistry();
        }
        if ((element = this.repositoryExtensionsByName.get(repositoryType)) != null) {
            return (RepositoryCreator)element.createExecutableExtension(REPOSITORY_CREATOR_CLASS_TAG);
        }
        return null;
    }

    public synchronized RepositoryStructurer getRepositoryStructurer(String repositoryType) throws CoreException {
        IConfigurationElement element;
        if (this.repositoryExtensionsByName == null) {
            this.initializeRegistry();
        }
        if ((element = this.repositoryExtensionsByName.get(repositoryType)) != null && element.getAttribute(REPOSITORY_STRUCTURER_CLASS_TAG) != null) {
            return (RepositoryStructurer)element.createExecutableExtension(REPOSITORY_STRUCTURER_CLASS_TAG);
        }
        return null;
    }
}

