/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.retro.util;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.mylyn.docs.intent.retro.API;
import org.eclipse.mylyn.docs.intent.retro.AcceptanceTest;
import org.eclipse.mylyn.docs.intent.retro.Bundle;
import org.eclipse.mylyn.docs.intent.retro.Category;
import org.eclipse.mylyn.docs.intent.retro.DevelopperFeature;
import org.eclipse.mylyn.docs.intent.retro.EndUserFeature;
import org.eclipse.mylyn.docs.intent.retro.Feature;
import org.eclipse.mylyn.docs.intent.retro.Interaction;
import org.eclipse.mylyn.docs.intent.retro.NameSpace;
import org.eclipse.mylyn.docs.intent.retro.Product;
import org.eclipse.mylyn.docs.intent.retro.Project;
import org.eclipse.mylyn.docs.intent.retro.RetroPackage;
import org.eclipse.mylyn.docs.intent.retro.RetroPlugin;
import org.eclipse.mylyn.docs.intent.retro.UnitTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroValidator
extends EObjectValidator {
    public static final String copyright = "Copyright (c) 2010, 2011 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n\tObeo - initial API and implementation\r\n";
    public static final RetroValidator INSTANCE = new RetroValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.mylyn.docs.intent.retro";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return RetroPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateBundle((Bundle)value, diagnostics, context);
            }
            case 1: {
                return this.validateNameSpace((NameSpace)value, diagnostics, context);
            }
            case 2: {
                return this.validateDevelopperFeature((DevelopperFeature)value, diagnostics, context);
            }
            case 3: {
                return this.validateEndUserFeature((EndUserFeature)value, diagnostics, context);
            }
            case 4: {
                return this.validateFeature((Feature)value, diagnostics, context);
            }
            case 5: {
                return this.validateAPI((API)value, diagnostics, context);
            }
            case 6: {
                return this.validateUnitTest((UnitTest)value, diagnostics, context);
            }
            case 7: {
                return this.validateProject((Project)value, diagnostics, context);
            }
            case 8: {
                return this.validateAcceptanceTest((AcceptanceTest)value, diagnostics, context);
            }
            case 9: {
                return this.validateProduct((Product)value, diagnostics, context);
            }
            case 10: {
                return this.validateInteraction((Interaction)value, diagnostics, context);
            }
            case 11: {
                return this.validateCategory((Category)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateBundle(Bundle bundle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)bundle, diagnostics, context);
    }

    public boolean validateNameSpace(NameSpace nameSpace, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)nameSpace, diagnostics, context);
    }

    public boolean validateDevelopperFeature(DevelopperFeature developperFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)developperFeature, diagnostics, context);
    }

    public boolean validateEndUserFeature(EndUserFeature endUserFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)endUserFeature, diagnostics, context);
    }

    public boolean validateFeature(Feature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)feature, diagnostics, context);
    }

    public boolean validateAPI(API api, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)api, diagnostics, context);
    }

    public boolean validateUnitTest(UnitTest unitTest, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)unitTest, diagnostics, context);
    }

    public boolean validateProject(Project project, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)project, diagnostics, context);
    }

    public boolean validateAcceptanceTest(AcceptanceTest acceptanceTest, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)acceptanceTest, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)acceptanceTest, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)acceptanceTest, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAcceptanceTest_IsValidAcceptanceTest(acceptanceTest, diagnostics, context);
        }
        return result;
    }

    public boolean validateAcceptanceTest_IsValidAcceptanceTest(AcceptanceTest acceptanceTest, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (acceptanceTest.getSwtBotClassName() == null || !acceptanceTest.getSwtBotClassName().endsWith("Test")) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, RetroPlugin.ID, 2, "Wrong name for this Acceptance test : should end with 'Test' suffix", new Object[0]));
        }
        if (acceptanceTest.getPackage() == null || !acceptanceTest.getPackage().contains("acceptance")) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, RetroPlugin.ID, 2, "Wrong package for this Acceptance test : should be located in a 'acceptance' package", new Object[0]));
        }
        return true;
    }

    public boolean validateProduct(Product product, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)product, diagnostics, context);
    }

    public boolean validateInteraction(Interaction interaction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)interaction, diagnostics, context);
    }

    public boolean validateCategory(Category category, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)category, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

