/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.compiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CompilationStatusSeverity implements Enumerator
{
    WARNING(0, "WARNING", "WARNING"),
    ERROR(1, "ERROR", "ERROR"),
    INFO(2, "INFO", "INFO"),
    OK(3, "OK", "OK");

    public static final int WARNING_VALUE = 0;
    public static final int ERROR_VALUE = 1;
    public static final int INFO_VALUE = 2;
    public static final int OK_VALUE = 3;
    private static final CompilationStatusSeverity[] VALUES_ARRAY;
    public static final List<CompilationStatusSeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompilationStatusSeverity[]{WARNING, ERROR, INFO, OK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompilationStatusSeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompilationStatusSeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompilationStatusSeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompilationStatusSeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompilationStatusSeverity get(int value) {
        switch (value) {
            case 0: {
                return WARNING;
            }
            case 1: {
                return ERROR;
            }
            case 2: {
                return INFO;
            }
            case 3: {
                return OK;
            }
        }
        return null;
    }

    private CompilationStatusSeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

