/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Code;
import org.eclipse.mylyn.docs.intent.markup.markup.Container;
import org.eclipse.mylyn.docs.intent.markup.markup.Entity;
import org.eclipse.mylyn.docs.intent.markup.markup.Image;
import org.eclipse.mylyn.docs.intent.markup.markup.Link;
import org.eclipse.mylyn.docs.intent.markup.markup.List;
import org.eclipse.mylyn.docs.intent.markup.markup.ListItem;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;
import org.eclipse.mylyn.docs.intent.markup.markup.Preformatted;
import org.eclipse.mylyn.docs.intent.markup.markup.Quote;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.Table;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;
import org.eclipse.mylyn.docs.intent.markup.markup.util.MarkupSwitch;
import org.eclipse.mylyn.docs.intent.markup.serializer.BlockSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.ContainerSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.EntitySerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.ImageSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.LinkSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.ListItemSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.ListSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.SectionSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.TableSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.TextSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTextElementDispatcher
extends MarkupSwitch<String> {
    @Override
    public String caseBlock(Block object) {
        return BlockSerializer.render(object, this);
    }

    @Override
    public String caseCode(Code object) {
        String jumpLine = "";
        if (!BlockSerializer.usePrefix().booleanValue()) {
            jumpLine = "\n";
        }
        return BlockSerializer.renderWithBlocPrefix(object, this, String.valueOf(jumpLine) + "bc.." + ' ' + "\n");
    }

    @Override
    public String caseContainer(Container object) {
        return ContainerSerializer.render(object, this);
    }

    @Override
    public String caseEntity(Entity object) {
        return EntitySerializer.render(object);
    }

    @Override
    public String caseLink(Link object) {
        return LinkSerializer.render(object, this);
    }

    @Override
    public String caseList(List object) {
        String prefix = "";
        if (BlockSerializer.usePrefix().booleanValue()) {
            prefix = "\np. \n";
        }
        return String.valueOf(prefix) + ListSerializer.render(object, this);
    }

    @Override
    public String caseListItem(ListItem object) {
        return ListItemSerializer.render(object, this);
    }

    @Override
    public String caseImage(Image object) {
        return ImageSerializer.render(object);
    }

    @Override
    public String caseParagraph(Paragraph object) {
        if (BlockSerializer.usePrefix().booleanValue()) {
            return BlockSerializer.renderWithBlocPrefix(object, this, "\np. \n");
        }
        return BlockSerializer.render(object, this);
    }

    @Override
    public String casePreformatted(Preformatted object) {
        return BlockSerializer.renderWithBlocPrefix(object, this, "\npre.. \n");
    }

    @Override
    public String caseQuote(Quote object) {
        return BlockSerializer.renderWithBlocPrefix(object, this, "\nbq.. \n");
    }

    @Override
    public String caseSection(Section section) {
        String jumpLine = "";
        if (BlockSerializer.usePrefix().booleanValue()) {
            jumpLine = "\n";
        }
        return String.valueOf(jumpLine) + SectionSerializer.render(section, this);
    }

    @Override
    public String caseTable(Table table) {
        return TableSerializer.render(table, this);
    }

    @Override
    public String caseText(Text object) {
        return TextSerializer.render(object);
    }
}

