/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotBase;

final class TextFileSnapshotWs
extends TextFileSnapshotBase {
    private final IFile file;
    private final long modificationStamp;
    private Reference<String> contents;
    private String charset;
    private volatile IStatus status = Status.OK_STATUS;

    TextFileSnapshotWs(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.modificationStamp = file.getModificationStamp();
    }

    @Override
    public synchronized String getContents() {
        if (!this.exists()) {
            return "";
        }
        String result = null;
        boolean current = this.isCurrent();
        if (this.contents != null) {
            if (!current) {
                this.contents = null;
            } else {
                result = this.contents.get();
            }
        }
        if (result == null && current) {
            try {
                this.cacheCharset();
                String currentContents = this.readContents();
                if (this.isCurrent()) {
                    result = currentContents;
                    this.contents = new SoftReference<String>(result);
                }
            }
            catch (CoreException e) {
                Activator.logError(e);
                this.status = Activator.createErrorStatus(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean exists() {
        return this.modificationStamp != -1L;
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        if (other instanceof TextFileSnapshotWs) {
            TextFileSnapshotWs otherSnapshot = (TextFileSnapshotWs)other;
            if (this.file.equals((Object)otherSnapshot.file)) {
                if (this.modificationStamp == otherSnapshot.modificationStamp) {
                    return true;
                }
                return false;
            }
        }
        if (!this.isCurrent()) {
            return false;
        }
        return null;
    }

    private boolean isCurrent() {
        return this.modificationStamp == this.file.getModificationStamp() && this.status.isOK();
    }

    private void cacheCharset() throws CoreException {
        if (this.charset == null) {
            this.charset = TextFileSnapshotWs.getCharset(this.file);
        }
    }

    static String getCharset(IFile file) throws CoreException {
        String charset = file.getCharset(false);
        if (charset == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream contents = file.getContents(false);){
                    charset = TextFileSnapshotWs.getCharset(contents, file.getName());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
            }
        }
        if (charset == null) {
            charset = file.getParent().getDefaultCharset();
        }
        return charset;
    }

    /*
     * Loose catch block
     */
    private String readContents() throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                InputStreamReader reader;
                InputStream stream;
                block18: {
                    block17: {
                        stream = this.file.getContents(false);
                        reader = new InputStreamReader(stream, this.charset);
                        string = String.valueOf(TextFileSnapshotWs.getInputStreamAsCharArray(stream, reader));
                        if (reader == null) break block17;
                        reader.close();
                    }
                    if (stream == null) break block18;
                    stream.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (stream != null) {
                                stream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    void clearContents() {
        this.contents.clear();
    }
}

