/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.junit.NoJobsWorkspaceTestCase;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotBase;
import org.eclipse.handly.snapshot.TextFileStoreSnapshot;

public class TextFileSnapshotTest
extends NoJobsWorkspaceTestCase {
    private IFile fileX;
    private IFile fileY;
    private IFile fileZ;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.setUpProject("Test002");
        this.fileX = p.getFile("x.txt");
        this.fileY = p.getFile("y.txt");
        this.fileZ = p.getFile("z.txt");
    }

    public void test01() throws Exception {
        this._testA(this.snapshotSupplier1(this.fileX), this.snapshotSupplier1(this.fileX));
        this._testA(this.snapshotSupplier1(this.fileX), this.snapshotSupplier2(this.fileX));
        this._testA(this.snapshotSupplier1(this.fileX), this.snapshotSupplier3(this.fileX));
    }

    public void test02() throws Exception {
        this._testA(this.snapshotSupplier1(this.fileX), this.snapshotSupplier1(this.fileY));
        this._testA(this.snapshotSupplier1(this.fileX), this.snapshotSupplier2(this.fileY));
        this._testA(this.snapshotSupplier1(this.fileX), this.snapshotSupplier3(this.fileY));
    }

    public void test03() throws Exception {
        this._testB(this.snapshotSupplier1(this.fileX), this.snapshotSupplier1(this.fileZ));
        this._testB(this.snapshotSupplier1(this.fileX), this.snapshotSupplier2(this.fileZ));
        this._testB(this.snapshotSupplier1(this.fileX), this.snapshotSupplier3(this.fileZ));
    }

    public void test04() throws Exception {
        this._testC(this.snapshotSupplier1(this.fileX));
    }

    public void test05() throws Exception {
        this._testD(this.snapshotSupplier1(this.fileX));
    }

    public void test06() throws Exception {
        this._testA(this.snapshotSupplier2(this.fileX), this.snapshotSupplier1(this.fileX));
        this._testA(this.snapshotSupplier2(this.fileX), this.snapshotSupplier2(this.fileX));
        this._testA(this.snapshotSupplier2(this.fileX), this.snapshotSupplier3(this.fileX));
    }

    public void test07() throws Exception {
        this._testA(this.snapshotSupplier2(this.fileX), this.snapshotSupplier1(this.fileY));
        this._testA(this.snapshotSupplier2(this.fileX), this.snapshotSupplier2(this.fileY));
        this._testA(this.snapshotSupplier2(this.fileX), this.snapshotSupplier3(this.fileY));
    }

    public void test08() throws Exception {
        this._testB(this.snapshotSupplier2(this.fileX), this.snapshotSupplier1(this.fileZ));
        this._testB(this.snapshotSupplier2(this.fileX), this.snapshotSupplier2(this.fileZ));
        this._testB(this.snapshotSupplier2(this.fileX), this.snapshotSupplier3(this.fileZ));
    }

    public void test09() throws Exception {
        this._testC(this.snapshotSupplier2(this.fileX));
    }

    public void test10() throws Exception {
        this._testD(this.snapshotSupplier2(this.fileX));
    }

    public void test11() throws Exception {
        this._testA(this.snapshotSupplier3(this.fileX), this.snapshotSupplier1(this.fileX));
        this._testA(this.snapshotSupplier3(this.fileX), this.snapshotSupplier2(this.fileX));
        this._testA(this.snapshotSupplier3(this.fileX), this.snapshotSupplier3(this.fileX));
    }

    public void test12() throws Exception {
        this._testA(this.snapshotSupplier3(this.fileX), this.snapshotSupplier1(this.fileY));
        this._testA(this.snapshotSupplier3(this.fileX), this.snapshotSupplier2(this.fileY));
        this._testA(this.snapshotSupplier3(this.fileX), this.snapshotSupplier3(this.fileY));
    }

    public void test13() throws Exception {
        this._testB(this.snapshotSupplier3(this.fileX), this.snapshotSupplier1(this.fileZ));
        this._testB(this.snapshotSupplier3(this.fileX), this.snapshotSupplier2(this.fileZ));
        this._testB(this.snapshotSupplier3(this.fileX), this.snapshotSupplier3(this.fileZ));
    }

    public void test14() throws Exception {
        this._testC(this.snapshotSupplier3(this.fileX));
    }

    public void test15() throws Exception {
        this._testD(this.snapshotSupplier3(this.fileX));
    }

    private Supplier<TextFileSnapshotBase> snapshotSupplier1(IFile file) {
        return () -> new TextFileSnapshot(file, TextFileSnapshot.Layer.WORKSPACE);
    }

    private Supplier<TextFileSnapshotBase> snapshotSupplier2(IFile file) {
        return () -> new TextFileSnapshot(file, TextFileSnapshot.Layer.FILESYSTEM);
    }

    private Supplier<TextFileSnapshotBase> snapshotSupplier3(IFile file) {
        return () -> {
            IFileStore fileStore;
            try {
                fileStore = EFS.getStore((URI)file.getLocationURI());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            return new TextFileStoreSnapshot(fileStore);
        };
    }

    private void _testA(Supplier<TextFileSnapshotBase> supplier, Supplier<TextFileSnapshotBase> otherSupplier) {
        TextFileSnapshotBase snapshot1 = supplier.get();
        TextFileSnapshotBase snapshot2 = otherSupplier.get();
        TextFileSnapshotTest.assertNotSame((Object)snapshot1, (Object)snapshot2);
        TextFileSnapshotTest.assertTrue((boolean)snapshot1.isEqualTo((ISnapshot)snapshot2));
    }

    private void _testB(Supplier<TextFileSnapshotBase> supplier, Supplier<TextFileSnapshotBase> otherSupplier) {
        TextFileSnapshotBase snapshot1 = supplier.get();
        TextFileSnapshotBase snapshot2 = otherSupplier.get();
        TextFileSnapshotTest.assertFalse((boolean)snapshot1.isEqualTo((ISnapshot)snapshot2));
    }

    private void _testC(Supplier<TextFileSnapshotBase> snapshotSupplier) throws Exception {
        TextFileSnapshotBase snapshot = snapshotSupplier.get();
        TextFileSnapshotTest.assertTrue((boolean)snapshot.exists());
        TextFileSnapshotTest.assertTrue((boolean)snapshot.getStatus().isOK());
        TextFileSnapshotTest.assertEquals((String)"hello", (String)snapshot.getContents());
        this.fileX.appendContents((InputStream)new ByteArrayInputStream(", world!".getBytes()), true, false, null);
        TextFileSnapshotBase snapshot2 = snapshotSupplier.get();
        TextFileSnapshotTest.assertTrue((boolean)snapshot2.exists());
        TextFileSnapshotTest.assertTrue((boolean)snapshot2.getStatus().isOK());
        TextFileSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
        TextFileSnapshotTest.assertFalse((boolean)snapshot.isEqualTo((ISnapshot)snapshot2));
    }

    private void _testD(Supplier<TextFileSnapshotBase> snapshotSupplier) throws Exception {
        TextFileSnapshotBase snapshot = snapshotSupplier.get();
        TextFileSnapshotTest.assertTrue((boolean)snapshot.exists());
        TextFileSnapshotTest.assertTrue((boolean)snapshot.getStatus().isOK());
        TextFileSnapshotTest.assertEquals((String)"hello", (String)snapshot.getContents());
        this.fileX.delete(true, null);
        TextFileSnapshotTest.assertTrue((boolean)snapshot.exists());
        TextFileSnapshotBase snapshot2 = snapshotSupplier.get();
        TextFileSnapshotTest.assertFalse((boolean)snapshot2.exists());
        TextFileSnapshotTest.assertTrue((boolean)snapshot2.getStatus().isOK());
        TextFileSnapshotTest.assertEquals((String)"", (String)snapshot2.getContents());
        TextFileSnapshotTest.assertFalse((boolean)snapshot.isEqualTo((ISnapshot)snapshot2));
    }
}

