/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import junit.framework.TestCase;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceConstruct;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class SourceElementTest
extends TestCase {
    private SimpleSourceFile a;
    private SimpleSourceConstruct b;
    private SourceElementBody aBody;
    private SourceElementBody bBody;

    protected void setUp() throws Exception {
        super.setUp();
        this.a = new SimpleSourceFile(null, "a.foo", null, new SimpleModelManager()){

            public Object findBody_() {
                return SourceElementTest.this.aBody;
            }
        };
        this.b = new SimpleSourceConstruct((IElementImplSupport)this.a, "B"){

            public Object findBody_() {
                return SourceElementTest.this.bBody;
            }
        };
        this.aBody = new SourceElementBody();
        this.aBody.setFullRange(new TextRange(0, 10));
        this.aBody.addChild((IElement)this.b);
        this.bBody = new SourceElementBody();
        this.bBody.setFullRange(new TextRange(3, 5));
    }

    public void test1() throws Exception {
        SourceElementTest.assertEquals((Object)((Object)this.a), (Object)this.a.getSourceElementAt_(0, Contexts.EMPTY_CONTEXT, null));
        SourceElementTest.assertEquals((Object)((Object)this.a), (Object)this.a.getSourceElementAt_(10, Contexts.EMPTY_CONTEXT, null));
        SourceElementTest.assertNull((Object)this.a.getSourceElementAt_(11, Contexts.EMPTY_CONTEXT, null));
        SourceElementTest.assertEquals((Object)((Object)this.b), (Object)this.a.getSourceElementAt_(3, Contexts.EMPTY_CONTEXT, null));
        SourceElementTest.assertEquals((Object)((Object)this.a), (Object)this.a.getSourceElementAt_(2, Contexts.EMPTY_CONTEXT, null));
        SourceElementTest.assertEquals((Object)((Object)this.b), (Object)this.a.getSourceElementAt_(8, Contexts.EMPTY_CONTEXT, null));
        SourceElementTest.assertEquals((Object)((Object)this.a), (Object)this.a.getSourceElementAt_(9, Contexts.EMPTY_CONTEXT, null));
    }

    public void test2() throws Exception {
        Document document = new Document("0123456789");
        DocumentSnapshot snapshot = new DocumentSnapshot((IDocument)document);
        this.aBody.setSnapshot((ISnapshot)snapshot);
        try {
            this.a.getSourceElementAt_(0, Contexts.EMPTY_CONTEXT, null);
            SourceElementTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        this.bBody.setSnapshot((ISnapshot)snapshot);
        this.test1();
        document.replace(0, 0, "0");
        DocumentSnapshot snapshot2 = new DocumentSnapshot((IDocument)document);
        try {
            this.a.getSourceElementAt_(0, Contexts.of((Property)Elements.BASE_SNAPSHOT, (Object)snapshot2), null);
            SourceElementTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        this.aBody.setSnapshot((ISnapshot)snapshot2);
        try {
            this.a.getSourceElementAt_(0, Contexts.of((Property)Elements.BASE_SNAPSHOT, (Object)snapshot2), null);
            SourceElementTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        this.bBody.setSnapshot((ISnapshot)snapshot2);
        SourceElementTest.assertEquals((Object)((Object)this.a), (Object)this.a.getSourceElementAt_(0, Contexts.of((Property)Elements.BASE_SNAPSHOT, (Object)snapshot2), null));
    }
}

