/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotWs;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ResourceTextFileBufferSnapshotTest
extends WorkspaceTestCase {
    private IFile file;
    private ITextFileBuffer buffer;
    private ITextFileBufferManager bufferManager = ITextFileBufferManager.DEFAULT;
    private TextFileBufferSnapshot snapshot;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.setUpProject("Test002");
        this.file = p.getFile("x.txt");
        this.bufferManager.connect(this.file.getFullPath(), LocationKind.IFILE, null);
        this.buffer = this.bufferManager.getTextFileBuffer(this.file.getFullPath(), LocationKind.IFILE);
        this.snapshot = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
    }

    protected void tearDown() throws Exception {
        this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        super.tearDown();
    }

    public void test1() throws Exception {
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        IDocumentExtension4 document = (IDocumentExtension4)this.buffer.getDocument();
        long modificationStamp = document.getModificationStamp();
        document.replace(0, 0, "", modificationStamp + 1L);
        document.replace(0, 0, "", modificationStamp);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
        modificationStamp = document.getModificationStamp();
        document.replace(0, 0, "", modificationStamp + 1L);
        document.replace(0, 0, "", modificationStamp);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
    }

    public void test2() throws Exception {
        this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
    }

    public void test3() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
        this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        this.bufferManager.connect(this.file.getFullPath(), LocationKind.IFILE, null);
        ITextFileBuffer newBuffer = this.bufferManager.getTextFileBuffer(this.file.getFullPath(), LocationKind.IFILE);
        newBuffer.getDocument().replace(0, "hello".length(), "good bye");
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        ResourceTextFileBufferSnapshotTest.assertFalse((boolean)"good bye".equals(snapshot2.getContents()));
    }

    public void test4() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        this.buffer.commit(null, true);
        this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
    }

    public void test5() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        this.buffer.commit(null, true);
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
    }

    public void test6() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        ResourceTextFileBufferSnapshotTest.assertTrue((boolean)this.buffer.isDirty());
        TextFileBufferSnapshot snapshot1 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot1.getContents());
        TextFileChange changeA = new TextFileChange("", this.file);
        changeA.setEdit((TextEdit)new ReplaceEdit(0, this.buffer.getDocument().getLength(), "good bye"));
        changeA.initializeValidationData(null);
        Change undoChangeA = changeA.perform((IProgressMonitor)new NullProgressMonitor());
        ResourceTextFileBufferSnapshotTest.assertTrue((boolean)this.buffer.isDirty());
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"good bye", (String)snapshot2.getContents());
        this.buffer.commit(null, true);
        TextFileChange changeB = new TextFileChange("", this.file);
        changeB.setEdit((TextEdit)new ReplaceEdit(0, this.buffer.getDocument().getLength(), "hello"));
        changeB.initializeValidationData(null);
        Change undoChangeB = changeB.perform((IProgressMonitor)new NullProgressMonitor());
        ResourceTextFileBufferSnapshotTest.assertFalse((boolean)this.buffer.isDirty());
        TextFileBufferSnapshot snapshot3 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)snapshot3.getContents());
        this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        ResourceTextFileBufferSnapshotTest.assertNull((Object)snapshot1.getContents());
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)snapshot3.getContents());
        undoChangeB.perform(null);
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"good bye", (String)snapshot2.getContents());
        undoChangeA.perform(null);
        ResourceTextFileBufferSnapshotTest.assertNull((Object)snapshot1.getContents());
        ResourceTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)new TextFileSnapshotWs(this.file).getContents());
    }
}

