/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.TextRange;

public interface ISourceElementImplSupport
extends IElementImplSupport,
ISourceElementImpl {
    @Override
    default public ISourceElementInfo getSourceElementInfo_(IContext context, IProgressMonitor monitor) throws CoreException {
        return (ISourceElementInfo)this.getBody_(context, monitor);
    }

    @Override
    default public ISourceElement getSourceElementAt_(int position, IContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ISourceElementInfo info = this.getSourceElementInfo_(context, (IProgressMonitor)subMonitor.split(1));
        if (!ISourceElementImplSupport.checkInRange(position, info, context)) {
            return null;
        }
        return this.getSourceElementAt_(position, info, context, (IProgressMonitor)subMonitor.split(1));
    }

    default public ISourceElement getSourceElementAt_(int position, ISourceElementInfo info, IContext context, IProgressMonitor monitor) throws CoreException {
        ISnapshot snapshot;
        if (context.get(Elements.BASE_SNAPSHOT) == null && (snapshot = info.getSnapshot()) != null) {
            context = Contexts.with(Contexts.of(Elements.BASE_SNAPSHOT, snapshot), context);
        }
        ISourceConstruct[] children = info.getChildren();
        SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
        ISourceConstruct[] iSourceConstructArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            SubMonitor iterationMonitor = loopMonitor.split(1);
            ISourceElement found = Elements.getSourceElementAt(child, position, context, (IProgressMonitor)iterationMonitor);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return this;
    }

    public static boolean checkInRange(int position, ISourceElementInfo info, IContext context) {
        ISnapshot base = context.get(Elements.BASE_SNAPSHOT);
        if (base != null && !base.isEqualTo(info.getSnapshot())) {
            throw new StaleSnapshotException();
        }
        TextRange textRange = info.getFullRange();
        return textRange != null && textRange.covers(position);
    }
}

