/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.Body;
import org.eclipse.handly.model.impl.support.Element;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.model.impl.support.SimpleElement;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceConstruct;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.ToStringOptions;

public class ElementTest
extends TestCase {
    private boolean rootExists;
    private SimpleElement root;
    private SimpleElement a;
    private SimpleSourceConstruct b;
    private SimpleSourceConstruct c;

    protected void setUp() throws Exception {
        super.setUp();
        this.rootExists = true;
        this.root = new SimpleElement(null, "root", new SimpleModelManager()){

            @Override
            public void validateExistence_(IContext context) throws CoreException {
                if (!ElementTest.this.rootExists) {
                    throw this.newDoesNotExistException_();
                }
            }

            @Override
            public void buildStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
                Body body = new Body();
                body.setChildren((IElement[])new Element[]{ElementTest.this.a, ElementTest.this.b});
                Map newElements = (Map)context.get(NEW_ELEMENTS);
                newElements.put(this, body);
                SourceElementBody bBody = new SourceElementBody();
                newElements.put(ElementTest.this.b, bBody);
                ElementTest.assertSame((Object)bBody, (Object)ElementTest.this.b.getBody_());
            }
        };
        this.a = this.root.getChild("A");
        this.b = new SimpleSourceConstruct((IElementImplSupport)this.root, "B");
        this.c = new SimpleSourceConstruct((IElementImplSupport)this.root, "C");
    }

    public void test01() throws Exception {
        ElementTest.assertNull((Object)this.root.findBody_());
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertNull((Object)this.b.findBody_());
        Body rootBody = (Body)this.root.getBody_();
        ElementTest.assertSame((Object)rootBody, (Object)this.root.peekAtBody_());
        ElementTest.assertEquals(Arrays.asList(new Element[]{this.a, this.b}), Arrays.asList(rootBody.getChildren()));
        SourceElementBody bBody = (SourceElementBody)this.b.peekAtBody_();
        ElementTest.assertNotNull((Object)bBody);
        ElementTest.assertNull((Object)this.a.peekAtBody_());
        Body aBody = (Body)this.a.getBody_();
        ElementTest.assertNotNull((Object)aBody);
        ElementTest.assertSame((Object)aBody, (Object)this.a.peekAtBody_());
        this.root.close_();
        ElementTest.assertNull((Object)this.root.findBody_());
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertNull((Object)this.b.findBody_());
    }

    public void test02() throws Exception {
        ElementTest.assertNull((Object)this.root.findBody_());
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertNull((Object)this.b.findBody_());
        SourceElementBody bBody = (SourceElementBody)this.b.getBody_();
        ElementTest.assertNotNull((Object)bBody);
        ElementTest.assertSame((Object)bBody, (Object)this.b.peekAtBody_());
        Body rootBody = (Body)this.root.peekAtBody_();
        ElementTest.assertEquals(Arrays.asList(new Element[]{this.a, this.b}), Arrays.asList(rootBody.getChildren()));
        ElementTest.assertNull((Object)this.a.peekAtBody_());
        this.b.close_();
        ElementTest.assertSame((Object)bBody, (Object)this.b.findBody_());
        ElementTest.assertSame((Object)rootBody, (Object)this.root.findBody_());
        this.root.close_();
        ElementTest.assertNull((Object)this.root.findBody_());
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertNull((Object)this.b.findBody_());
    }

    public void test03() throws Exception {
        ElementTest.assertNull((Object)this.root.findBody_());
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertNull((Object)this.b.findBody_());
        Body aBody = (Body)this.a.getBody_();
        ElementTest.assertNotNull((Object)aBody);
        ElementTest.assertSame((Object)aBody, (Object)this.a.peekAtBody_());
        Body rootBody = (Body)this.root.peekAtBody_();
        ElementTest.assertEquals(Arrays.asList(new Element[]{this.a, this.b}), Arrays.asList(rootBody.getChildren()));
        SourceElementBody bBody = (SourceElementBody)this.b.peekAtBody_();
        ElementTest.assertNotNull((Object)bBody);
        this.a.close_();
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertSame((Object)rootBody, (Object)this.root.findBody_());
        ElementTest.assertSame((Object)bBody, (Object)this.b.findBody_());
        this.root.close_();
        ElementTest.assertNull((Object)this.root.findBody_());
        ElementTest.assertNull((Object)this.a.findBody_());
        ElementTest.assertNull((Object)this.b.findBody_());
    }

    public void test04() {
        ElementTest.assertTrue((boolean)this.root.exists_());
        ElementTest.assertNull((Object)this.root.peekAtBody_());
    }

    public void test05() {
        ElementTest.assertTrue((boolean)this.a.exists_());
        ElementTest.assertNull((Object)this.a.peekAtBody_());
        ElementTest.assertNull((Object)this.root.peekAtBody_());
    }

    public void test06() {
        ElementTest.assertTrue((boolean)this.b.exists_());
        ElementTest.assertNotNull((Object)this.b.peekAtBody_());
        ElementTest.assertNotNull((Object)this.root.peekAtBody_());
        ElementTest.assertNull((Object)this.a.peekAtBody_());
    }

    public void test07() {
        ElementTest.assertFalse((boolean)this.c.exists_());
        ElementTest.assertNull((Object)this.c.peekAtBody_());
        ElementTest.assertNotNull((Object)this.root.peekAtBody_());
        ElementTest.assertNotNull((Object)this.b.peekAtBody_());
        ElementTest.assertNull((Object)this.a.peekAtBody_());
    }

    public void test08() {
        this.rootExists = false;
        ElementTest.assertFalse((boolean)this.root.exists_());
        try {
            this.root.getBody_();
            ElementTest.fail();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test09() {
        this.rootExists = false;
        ElementTest.assertFalse((boolean)this.a.exists_());
        try {
            this.a.getBody_();
            ElementTest.fail();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test10() {
        this.rootExists = false;
        ElementTest.assertFalse((boolean)this.b.exists_());
        try {
            this.b.getBody_();
            ElementTest.fail();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test11() {
        this.rootExists = false;
        this.root.getElementManager_().put((IElementImplSupport)this.root, Collections.singletonMap(this.root, new Body()));
        ElementTest.assertTrue((boolean)this.root.exists_());
    }

    public void test12() throws Exception {
        Body body = new Body();
        this.root.getElementManager_().put((IElementImplSupport)this.root, Collections.singletonMap(this.root, body));
        ElementTest.assertSame((Object)body, (Object)this.root.open_(Contexts.EMPTY_CONTEXT, null));
    }

    public void test13() throws Exception {
        ElementTest.assertEquals(Arrays.asList(new Element[]{this.a, this.b}), Arrays.asList((Element[])this.root.getChildrenOfType_(Element.class, Contexts.EMPTY_CONTEXT, null)));
        ElementTest.assertEquals(Arrays.asList(this.a), Arrays.asList((SimpleElement[])this.root.getChildrenOfType_(SimpleElement.class, Contexts.EMPTY_CONTEXT, null)));
        ElementTest.assertEquals(Arrays.asList(this.b), Arrays.asList((SimpleSourceConstruct[])this.root.getChildrenOfType_(SimpleSourceConstruct.class, Contexts.EMPTY_CONTEXT, null)));
    }

    public void test14() throws Exception {
        ElementTest.assertEquals((String)"root (not open)", (String)this.root.toString());
        this.root.getBody_();
        ElementTest.assertEquals((String)"root\n  A (not open)\n  B", (String)this.root.toString());
        ElementTest.assertEquals((String)"A (not open)", (String)this.a.toString());
        ElementTest.assertEquals((String)"B", (String)this.b.toString());
        SimpleElement foo = this.a.getChild("Foo");
        Body aBody = new Body();
        aBody.addChild((IElement)foo);
        this.a.getElementManager_().put((IElementImplSupport)this.a, Collections.singletonMap(this.a, aBody));
        ElementTest.assertEquals((String)"root\n  A\n    Foo (not open)\n  B", (String)this.root.toString());
        ElementTest.assertEquals((String)"A\n  Foo (not open)", (String)this.a.toString());
        ElementTest.assertEquals((String)"Foo (not open) [in A]", (String)foo.toString());
        SimpleElement bar = foo.getChild("Bar");
        Body fooBody = new Body();
        fooBody.addChild((IElement)bar);
        foo.getElementManager_().put((IElementImplSupport)foo, Collections.singletonMap(foo, fooBody));
        ElementTest.assertEquals((String)"root\n  A\n    Foo\n      Bar (not open)\n  B", (String)this.root.toString());
        ElementTest.assertEquals((String)"Foo [in A]\n  Bar (not open)", (String)foo.toString());
        ElementTest.assertEquals((String)"Bar (not open) [in Foo [in A]]", (String)bar.toString());
        ElementTest.assertEquals((String)"Foo\n  Bar (not open)", (String)foo.toString_(Contexts.of((Property)ToStringOptions.FORMAT_STYLE, (Object)ToStringOptions.FormatStyle.LONG)));
        ElementTest.assertEquals((String)"Foo [in A]", (String)foo.toString_(Contexts.of((Property)ToStringOptions.FORMAT_STYLE, (Object)ToStringOptions.FormatStyle.MEDIUM)));
        ElementTest.assertEquals((String)"Foo", (String)foo.toString_(Contexts.of((Property)ToStringOptions.FORMAT_STYLE, (Object)ToStringOptions.FormatStyle.SHORT)));
    }

    public void testBug530821() {
        class TestElement
        extends SimpleElement {
            TestElement(IElement parent) {
                super(parent, null, null);
            }

            public boolean equals(Object obj) {
                return obj instanceof TestElement;
            }
        }
        TestElement e1 = new TestElement(null);
        TestElement e2 = new TestElement((IElement)e1);
        ElementTest.assertEquals((Object)((Object)e1), (Object)((Object)e2));
        ElementTest.assertFalse((boolean)e1.equalsAndSameParentChain_((IElement)e2));
        ElementTest.assertTrue((boolean)e1.equalsAndSameParentChain_((IElement)new TestElement(null)));
    }
}

