/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;

public class Record {
    private int m_size = 0;
    private int m_type = 0;
    private byte[] m_data = null;

    protected Record() {
    }

    public Record(int type, int size, InputStream stream) throws IOException {
        this.m_type = type;
        this.m_size = size;
        this.readData(stream);
    }

    public int getType() {
        return this.m_type;
    }

    protected void setType(int type) {
        this.m_type = type;
    }

    public int getSize() {
        return this.m_size;
    }

    protected void setSize(int size) {
        this.m_size = size;
    }

    protected void readData(InputStream stream) throws IOException {
        this.m_data = new byte[this.m_size];
        stream.read(this.m_data, 0, this.m_size);
    }

    public long getDWORDAt(int offset) throws IOException {
        long retval = 0L;
        if (offset > this.m_size - 4) {
            throw new IOException("Read beyond end of data");
        }
        int byte1 = this.m_data[offset] & 0xFF;
        int byte2 = (this.m_data[offset + 1] & 0xFF) << 8;
        int byte3 = (this.m_data[offset + 2] & 0xFF) << 16;
        int byte4 = (this.m_data[offset + 3] & 0xFF) << 24;
        retval = byte1 + byte2 + byte3 + byte4 & 0xFFFFFFFF;
        return retval;
    }

    public int getIntAt(int offset) throws IOException {
        int retval = 0;
        if (offset > this.m_size - 4) {
            throw new IOException("Read beyond end of data");
        }
        int byte1 = this.m_data[offset] & 0xFF;
        int byte2 = (this.m_data[offset + 1] & 0xFF) << 8;
        int byte3 = (this.m_data[offset + 2] & 0xFF) << 16;
        int byte4 = (this.m_data[offset + 3] & 0xFF) << 24;
        retval = byte1 | byte2 | byte3 | byte4;
        return retval;
    }

    public short getShortAt(int offset) throws IOException {
        short retval = 0;
        if (offset > this.m_size - 2) {
            throw new IOException("Read beyond end of data");
        }
        int byte1 = this.m_data[offset] & 0xFF;
        int byte2 = (this.m_data[offset + 1] & 0xFF) << 8;
        retval = (short)(byte2 & 0xFFFF);
        retval = (short)(retval | (short)(byte1 & 0xFF));
        return retval;
    }

    public Color getColorAt(int offset) throws IOException {
        int colorref = (int)this.getDWORDAt(offset);
        int red = colorref & 0xFF;
        int green = (colorref & 0xFF00) >> 8;
        int blue = (colorref & 0xFF0000) >> 16;
        return new Color(red, green, blue);
    }

    public int getByteAt(int offset) throws IOException {
        int retval = 0;
        if (offset >= this.m_size) {
            throw new IOException("Read beyond end of data");
        }
        retval = this.m_data[offset] & 0xFF;
        return retval;
    }

    public byte[] getBytesAt(int offset, int count) throws IOException {
        byte[] retval = null;
        if (offset + count <= this.m_size) {
            retval = new byte[count];
            int i = 0;
            while (i < count) {
                retval[i] = this.m_data[offset + i];
                ++i;
            }
        } else {
            throw new IOException("Read beyond end of data");
        }
        return retval;
    }

    public Dimension getDimensionLAt(int offset) throws IOException {
        int w = this.getIntAt(offset);
        int h = this.getIntAt(offset + 4);
        return new Dimension(w, h);
    }

    public Dimension getDimensionAt(int offset) throws IOException {
        short w = this.getShortAt(offset);
        short h = this.getShortAt(offset + 2);
        return new Dimension(w, h);
    }

    public Point getPointAt(int offset) throws IOException {
        short x = this.getShortAt(offset);
        short y = this.getShortAt(offset + 2);
        return new Point(x, y);
    }

    public Point getPointLAt(int offset) throws IOException {
        int x = this.getIntAt(offset);
        int y = this.getIntAt(offset + 4);
        return new Point(x, y);
    }

    public Rectangle getRectangeAt(int offset) throws IOException {
        short x = this.getShortAt(offset);
        short y = this.getShortAt(offset + 2);
        short w = this.getShortAt(offset + 4);
        short h = this.getShortAt(offset + 6);
        return new Rectangle(x, y, w, h);
    }

    public Rectangle getRectangleLAt(int offset) throws IOException {
        int x = this.getIntAt(offset);
        int y = this.getIntAt(offset + 4);
        int x1 = this.getIntAt(offset + 8);
        int y1 = this.getIntAt(offset + 12);
        int w = x1 - x;
        int h = y1 - y;
        return new Rectangle(x, y, w, h);
    }

    public float[] getTransformAt(int offset) throws IOException {
        float[] xform = new float[6];
        int i = 0;
        while (i < 6) {
            xform[i] = this.getFloatAt(offset + i * 4);
            ++i;
        }
        return xform;
    }

    public float getFloatAt(int offset) throws IOException {
        int bits = (int)(this.getDWORDAt(offset) & 0xFFFFFFFFFFFFFFFFL);
        return Float.intBitsToFloat(bits);
    }

    public char[] getCharsAt(int offset, int numChars) throws IOException {
        char[] retval = null;
        if (offset + numChars * 2 < this.m_size) {
            retval = new char[numChars];
            int index = 0;
            while (index < numChars) {
                char lowByte = (char)(this.m_data[offset + index * 2] & 0xFF);
                char highByte = (char)(this.m_data[offset + 1 + index * 2] & 0xFF);
                retval[index] = (char)(lowByte + (highByte << 8));
                ++index;
            }
        } else {
            throw new IOException("Read beyond end of data");
        }
        return retval;
    }

    protected long readDWORD(InputStream stream) throws IOException {
        int byte1 = stream.read();
        int byte2 = stream.read();
        int byte3 = stream.read();
        int byte4 = stream.read();
        int retval = byte1 + (byte2 << 8) + (byte3 << 16) + (byte4 << 24);
        return retval;
    }

    protected int readShort(InputStream stream) throws IOException {
        int byte1 = stream.read();
        int byte2 = stream.read();
        int retval = byte1 + (byte2 << 8);
        return retval;
    }
}

