/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.odt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gendoc.documents.AbstractTableService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.table.Cell;
import org.eclipse.gendoc.table.Row;
import org.eclipse.gendoc.table.Table;
import org.eclipse.gendoc.tags.ITag;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ODTTableService
extends AbstractTableService {
    public String manageTable(ITag tag, IDocumentService documentService, StringBuffer returnValue, Object tableModel, Node tableNode) throws InvalidContentException {
        Node mainTable = tableNode.getFirstChild();
        if (documentService.isTable(mainTable.getNodeName()) && tableModel instanceof Table) {
            int nbCol = ((Table)tableModel).getColCount();
            String colLabel = "table:table-column";
            int index_col_start = returnValue.indexOf("<" + colLabel);
            returnValue.insert(index_col_start + colLabel.length() + 1, " table:number-columns-repeated=\"" + nbCol + "\"");
            Node rowNode = this.getChildNode(documentService.getRowLabel(), mainTable);
            String rowLabel = documentService.getRowLabel();
            Pattern rowPattern = Pattern.compile("<" + rowLabel + "[^<>]*>.*</" + rowLabel + ">");
            Matcher rowm = rowPattern.matcher(returnValue);
            int index_row_start = 0;
            int index_row_end = 0;
            if (rowm.find()) {
                index_row_start = rowm.start();
                index_row_end = returnValue.lastIndexOf("</" + rowLabel + ">");
                String row = returnValue.substring(index_row_start, index_row_end + rowLabel.length() + 3);
                String cellLabel = documentService.getCellLabel();
                int index_cell_start = row.indexOf("<" + cellLabel);
                int index_cell_end = row.lastIndexOf("</" + cellLabel + ">");
                Node cellNode = this.getChildNode(documentService.getCellLabel(), rowNode);
                if (cellNode != null) {
                    StringBuffer colNodetxt = new StringBuffer(documentService.asText(cellNode));
                    String txtLabel = "text:p";
                    Pattern txtPattern = Pattern.compile("<" + txtLabel + "[^<>]*>.*</" + txtLabel + ">");
                    Matcher txtm = txtPattern.matcher(colNodetxt);
                    if (txtm.find()) {
                        String style = "";
                        return this.generateTable(returnValue, tableModel, rowLabel, index_row_start, index_row_end, row, cellLabel, index_cell_start, index_cell_end, colNodetxt, txtm, style, txtLabel);
                    }
                }
            }
        }
        return null;
    }

    private Node getChildNode(String label, Node node) {
        NodeList rowChildNodes = node.getChildNodes();
        int i = 0;
        while (i < rowChildNodes.getLength()) {
            Node current = rowChildNodes.item(i);
            if (current.getNodeName() == label) {
                return current;
            }
            ++i;
        }
        return null;
    }

    private String generateTable(StringBuffer returnValue, Object tableModel, String rowLabel, int index_row_start, int index_row_end, String row, String colLabel, int index_col_start, int index_col_end, StringBuffer colNodetxt, Matcher txtm, String style, String txtLabel) {
        String rows = "";
        String cells = "";
        StringBuffer newRow = new StringBuffer(row);
        cells = this.generateCells((EList<Cell>)((Table)tableModel).getTableheader().getCells(), colNodetxt, txtm, style, txtLabel);
        newRow.replace(index_col_start, index_col_end + colLabel.length() + 3, cells);
        rows = String.valueOf(rows) + newRow.toString();
        for (Row r : ((Table)tableModel).getRows()) {
            newRow = new StringBuffer(row);
            cells = this.generateCells((EList<Cell>)r.getCells(), colNodetxt, txtm, style, txtLabel);
            newRow.replace(index_col_start, index_col_end + colLabel.length() + 3, cells);
            rows = String.valueOf(rows) + newRow.toString();
        }
        return returnValue.replace(index_row_start, index_row_end + rowLabel.length() + 3, rows).toString();
    }

    private String generateCells(EList<Cell> modelCells, StringBuffer colNodetxt, Matcher txtm, String style, String txtLabel) {
        String cols = "";
        for (Cell cell : modelCells) {
            int txtindex = txtm.end() - txtLabel.length() - 3;
            StringBuffer newCol = new StringBuffer(colNodetxt.toString());
            newCol.insert(txtindex, cell.getLabel());
            cols = String.valueOf(cols) + newCol.toString();
        }
        return cols;
    }
}

