/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.ConditionalStyleSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionKey;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.GetConditionalStyle;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.GetStyleDescription;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramInternalQuery;
import org.eclipse.sirius.diagram.business.internal.query.EAttributeCustomizationQuery;
import org.eclipse.sirius.diagram.business.internal.query.StyleDescriptionQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;
import org.eclipse.sirius.viewpoint.description.EStructuralFeatureCustomization;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class BestStyleDescriptionRegistry
extends HashMap<BestStyleDescriptionKey, StyleDescription> {
    public static final String DANNOTATION_CUSTOMIZATION_KEY = "DANNOTATION_CUSTOMIZATION_KEY";
    private static final long serialVersionUID = 1L;
    private IInterpreter interpreter;

    public BestStyleDescriptionRegistry(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public StyleDescription get(Object key) {
        BestStyleDescriptionKey bestStyleDescriptionKey;
        StyleDescription bestStyleDescription = (StyleDescription)super.get(key);
        if (bestStyleDescription == null && key instanceof BestStyleDescriptionKey && (bestStyleDescription = this.getBestStyleDescription(bestStyleDescriptionKey = (BestStyleDescriptionKey)key)) != null) {
            this.put(bestStyleDescriptionKey, bestStyleDescription);
        }
        return bestStyleDescription;
    }

    private StyleDescription getBestStyleDescription(BestStyleDescriptionKey bestStyleDescriptionKey) {
        StyleDescription result = null;
        DiagramElementMapping diagramElementMapping = bestStyleDescriptionKey.getDiagramElementMapping();
        DDiagram dDiagram = bestStyleDescriptionKey.getDDiagram();
        EObject modelElement = bestStyleDescriptionKey.getModelElement();
        EObject viewVariable = bestStyleDescriptionKey.getViewVariable();
        EObject containerVariable = bestStyleDescriptionKey.getContainerVariable();
        Iterator<? extends ConditionalStyleDescription> it = this.getConditionalStyles(diagramElementMapping, dDiagram).iterator();
        while (it.hasNext() && result == null) {
            ConditionalStyleDescription condStyle = it.next();
            if (!ConditionalStyleSpecOperations.checkPredicate(condStyle, modelElement, viewVariable, containerVariable, this.interpreter)) continue;
            result = this.getStyleDescription(condStyle);
        }
        if (result == null) {
            result = MappingHelper.getDefaultStyleDescription(diagramElementMapping);
        }
        if (result != null) {
            result = this.getCustomizedBestStyleDescription(result, bestStyleDescriptionKey);
        }
        return result;
    }

    private StyleDescription getCustomizedBestStyleDescription(StyleDescription styleDescription, BestStyleDescriptionKey bestStyleDescriptionKey) {
        StyleDescription customizedStyleDescription = styleDescription;
        StyleDescriptionQuery styleDescriptionQuery = new StyleDescriptionQuery(styleDescription);
        Map<EStructuralFeatureCustomization, Set<EObject>> eStructuralFeatureCustomizationAppliedOn = styleDescriptionQuery.getEStructuralFeatureCustomizationAppliedOn(bestStyleDescriptionKey, this.interpreter);
        if (!eStructuralFeatureCustomizationAppliedOn.isEmpty()) {
            customizedStyleDescription = (StyleDescription)EcoreUtil.copy((EObject)styleDescription);
            for (Map.Entry<EStructuralFeatureCustomization, Set<EObject>> entry : eStructuralFeatureCustomizationAppliedOn.entrySet()) {
                EStructuralFeatureCustomization featureCustomization = entry.getKey();
                Set<EObject> appliedOn = entry.getValue();
                if (featureCustomization instanceof EAttributeCustomization) {
                    EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)featureCustomization;
                    this.applyEAttributeCustomization(eAttributeCustomization, styleDescription, customizedStyleDescription, appliedOn, bestStyleDescriptionKey);
                    continue;
                }
                if (!(featureCustomization instanceof EReferenceCustomization)) continue;
                EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)featureCustomization;
                this.applyEReferenceCustomization(eReferenceCustomization, styleDescription, customizedStyleDescription, appliedOn);
            }
            customizedStyleDescription = this.storeInDDiagram(customizedStyleDescription, bestStyleDescriptionKey);
        }
        return customizedStyleDescription;
    }

    private StyleDescription storeInDDiagram(StyleDescription customizedStyleDescription, BestStyleDescriptionKey bestStyleDescriptionKey) {
        DDiagram dDiagram = bestStyleDescriptionKey.getDDiagram();
        ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = new DDiagramInternalQuery(dDiagram).getComputedStyleDescriptionRegistry(true);
        StyleDescription found = null;
        for (StyleDescription computedStyleDescription : computedStyleDescriptionRegistry.getComputedStyleDescriptions()) {
            if (!EcoreUtil.equals((EObject)customizedStyleDescription, (EObject)computedStyleDescription)) continue;
            found = computedStyleDescription;
            break;
        }
        if (found == null) {
            computedStyleDescriptionRegistry.getComputedStyleDescriptions().add((Object)customizedStyleDescription);
            found = customizedStyleDescription;
        }
        return found;
    }

    private void applyEAttributeCustomization(EAttributeCustomization eAttributeCustomization, StyleDescription styleDescription, StyleDescription customizedStyleDescription, Set<EObject> appliedOn, BestStyleDescriptionKey bestStyleDescriptionKey) {
        String attributeName = eAttributeCustomization.getAttributeName();
        Set<EObject> realEltsToCustomize = this.getRealElementsToCustomize(styleDescription, customizedStyleDescription, appliedOn, (EStructuralFeatureCustomization)eAttributeCustomization);
        if (!realEltsToCustomize.isEmpty()) {
            EAttributeCustomizationQuery eAttributeCustomizationQuery = new EAttributeCustomizationQuery(eAttributeCustomization);
            Object newAttributeValue = eAttributeCustomizationQuery.getNewAttributeValue(bestStyleDescriptionKey, this.interpreter);
            for (EObject realEltToCustomize : realEltsToCustomize) {
                EStructuralFeature eStructuralFeature = realEltToCustomize.eClass().getEStructuralFeature(attributeName);
                if (!(eStructuralFeature instanceof EAttribute) || newAttributeValue == null) continue;
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                Object convertedNewValue = this.getConvertedValue(newAttributeValue, eAttribute);
                Class instanceClass = eAttribute.getEAttributeType().getInstanceClass();
                if (eAttribute.isMany()) {
                    instanceClass = Collection.class;
                } else if (instanceClass.isPrimitive()) {
                    instanceClass = Primitives.wrap(instanceClass);
                }
                if (convertedNewValue == null || !instanceClass.isAssignableFrom(convertedNewValue.getClass())) continue;
                realEltToCustomize.eSet((EStructuralFeature)eAttribute, convertedNewValue);
            }
        }
    }

    private Object getConvertedValue(Object newAttributeValue, EAttribute eAttribute) {
        ArrayList<Object> convertedValue = newAttributeValue;
        EDataType eAttributeType = eAttribute.getEAttributeType();
        if (eAttribute.isMany()) {
            ArrayList<Object> manyConvertedObject = new ArrayList<Object>();
            if (newAttributeValue instanceof Collection) {
                Collection newAttributeValues = newAttributeValue;
                for (Object newAttributeStringValue : newAttributeValues) {
                    manyConvertedObject.add(this.getConvertedValue(newAttributeStringValue, eAttributeType));
                }
            } else {
                manyConvertedObject.add(this.getConvertedValue((Object)newAttributeValue, eAttributeType));
            }
            convertedValue = manyConvertedObject;
        } else {
            convertedValue = this.getConvertedValue((Object)newAttributeValue, eAttributeType);
        }
        return convertedValue;
    }

    private Object getConvertedValue(Object newAttributeValue, EDataType eAttributeType) {
        Object convertedValue = newAttributeValue;
        if (newAttributeValue instanceof String) {
            Object convertedObject;
            String newAttributeStringValue = (String)newAttributeValue;
            convertedValue = convertedObject = EcoreUtil.createFromString((EDataType)eAttributeType, (String)newAttributeStringValue);
        } else if (eAttributeType instanceof EEnum & newAttributeValue instanceof Enumerator) {
            convertedValue = newAttributeValue;
        }
        return convertedValue;
    }

    private void applyEReferenceCustomization(EReferenceCustomization eReferenceCustomization, StyleDescription styleDescription, StyleDescription customizedStyleDescription, Set<EObject> appliedOn) {
        Set<EObject> realEltsToCustomize = this.getRealElementsToCustomize(styleDescription, customizedStyleDescription, appliedOn, (EStructuralFeatureCustomization)eReferenceCustomization);
        for (EObject realEltToCustomize : realEltsToCustomize) {
            EStructuralFeature eStructuralFeature = realEltToCustomize.eClass().getEStructuralFeature(eReferenceCustomization.getReferenceName());
            if (!(eStructuralFeature instanceof EReference)) continue;
            realEltToCustomize.eSet(eStructuralFeature, (Object)eReferenceCustomization.getValue());
        }
    }

    private Set<EObject> getRealElementsToCustomize(StyleDescription styleDescription, StyleDescription customizedStyleDescription, Set<EObject> appliedOn, EStructuralFeatureCustomization eStructuralFeatureCustomization) {
        LinkedHashSet<EObject> realEltsToCustomize = new LinkedHashSet<EObject>();
        if (appliedOn.contains(styleDescription) && this.hasFeatureName((EObject)styleDescription, eStructuralFeatureCustomization)) {
            realEltsToCustomize.add((EObject)customizedStyleDescription);
        }
        TreeIterator styleDescriptionContent = styleDescription.eAllContents();
        while (styleDescriptionContent.hasNext()) {
            EObject next = (EObject)styleDescriptionContent.next();
            if (!appliedOn.contains(next) || !this.hasFeatureName(next, eStructuralFeatureCustomization)) continue;
            Object object = customizedStyleDescription.eGet(next.eContainingFeature());
            if (object instanceof EObject) {
                realEltsToCustomize.add((EObject)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (Object obj : list) {
                if (!(obj instanceof EObject)) continue;
                realEltsToCustomize.add((EObject)obj);
            }
        }
        return realEltsToCustomize;
    }

    private boolean hasFeatureName(EObject eObject, EStructuralFeatureCustomization eStructuralFeatureCustomization) {
        boolean hasFeatureName = false;
        if (eStructuralFeatureCustomization instanceof EAttributeCustomization) {
            EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)eStructuralFeatureCustomization;
            String attributeName = eAttributeCustomization.getAttributeName();
            hasFeatureName = eObject.eClass().getEStructuralFeature(attributeName) instanceof EAttribute;
        } else if (eStructuralFeatureCustomization instanceof EReferenceCustomization) {
            EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)eStructuralFeatureCustomization;
            String referenceName = eReferenceCustomization.getReferenceName();
            hasFeatureName = eObject.eClass().getEStructuralFeature(referenceName) instanceof EReference;
        }
        return hasFeatureName;
    }

    private List<? extends ConditionalStyleDescription> getConditionalStyles(DiagramElementMapping mapping, DDiagram diagram) {
        return (List)new GetConditionalStyle(diagram).doSwitch((EObject)mapping);
    }

    private StyleDescription getStyleDescription(ConditionalStyleDescription conditionalStyleDescription) {
        return (StyleDescription)new GetStyleDescription().doSwitch((EObject)conditionalStyleDescription);
    }
}

