/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.find;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.sirius.common.tools.api.find.AbstractFindLabelEngine;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirStyleDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FigureQuery;
import org.eclipse.sirius.ext.base.Option;

public class BasicFindLabelEngine
extends AbstractFindLabelEngine {
    private static final Predicate<EditPart> IS_LABEL_EDIT_PART = new Predicate<EditPart>(){

        public boolean apply(EditPart part) {
            boolean result = part instanceof AbstractGraphicalEditPart && part instanceof ITextAwareEditPart ? true : part instanceof IGraphicalEditPart && ((IGraphicalEditPart)part).getFigure() instanceof AirStyleDefaultSizeNodeFigure;
            return result;
        }
    };
    protected List allDiagramLabels;
    protected DiagramEditor editor;

    public BasicFindLabelEngine(DiagramEditor currentEditor) {
        this.editor = currentEditor;
    }

    protected List filterLabels(String search) {
        ArrayList<AbstractGraphicalEditPart> result = new ArrayList<AbstractGraphicalEditPart>();
        for (Object obj : this.allLabels()) {
            AbstractGraphicalEditPart label = (AbstractGraphicalEditPart)obj;
            if (!this.matches(label, search)) continue;
            result.add(label);
        }
        return result;
    }

    private boolean matches(AbstractGraphicalEditPart label, String search) {
        return this.matches(this.getText(label), search);
    }

    private boolean matches(String text, String search) {
        return text.indexOf(search) != -1;
    }

    private String getText(AbstractGraphicalEditPart label) {
        IFigure figure = label.getFigure();
        String text = this.getText(figure);
        return text != null ? text : "";
    }

    private String getText(IFigure figure) {
        Option<String> result = new FigureQuery(figure).getText();
        if (result.some()) {
            return (String)result.get();
        }
        return null;
    }

    private List allLabels() {
        if (this.allDiagramLabels == null) {
            this.findAllDiagramLabels();
        }
        return this.allDiagramLabels;
    }

    private void findAllDiagramLabels() {
        this.allDiagramLabels = new ArrayList();
        this.allDiagramLabels.addAll(Collections2.filter(this.findAllEditParts(), IS_LABEL_EDIT_PART));
    }

    private Collection<? extends EditPart> findAllEditParts() {
        DiagramEditPart diagram = this.editor.getDiagramEditPart();
        ArrayList roots = Lists.newArrayList((Object[])new DiagramEditPart[]{diagram});
        roots.addAll(diagram.getConnections());
        ArrayList editParts = new ArrayList();
        for (EditPart root : roots) {
            this.addAllContainedEditParts(root, editParts);
        }
        return editParts;
    }

    private void addAllContainedEditParts(EditPart ep, Collection coll) {
        coll.add(ep);
        for (Object child : ep.getChildren()) {
            this.addAllContainedEditParts((EditPart)child, coll);
        }
    }
}

