/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import com.google.common.collect.Iterables;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusDefaultSizeNodeFigure;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;
import org.eclipse.swt.graphics.Color;

public class ContainerWithTitleBlockFigure
extends SiriusDefaultSizeNodeFigure {
    private DStylizable viewNode;
    private LabelBorderStyleDescription labelBorderStyleDescription;

    public ContainerWithTitleBlockFigure(int width, int height, DStylizable viewNode, LabelBorderStyleDescription labelBorderStyleDescription) {
        super(width, height);
        this.viewNode = viewNode;
        this.labelBorderStyleDescription = labelBorderStyleDescription;
    }

    protected void paintBorder(Graphics graphics) {
        ViewNodeContainerFigureDesc child;
        SiriusWrapLabel containerLabelFigure;
        super.paintBorder(graphics);
        graphics.setLineStyle(1);
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.geBorderColor());
        Iterable filter = Iterables.filter((Iterable)this.getChildren(), ViewNodeContainerFigureDesc.class);
        if (Iterables.size((Iterable)filter) == 1 && (containerLabelFigure = (child = (ViewNodeContainerFigureDesc)filter.iterator().next()).getLabelFigure()) != null && containerLabelFigure.isVisible() && "labelBorderStyleWithBeveledCorner".equals(this.labelBorderStyleDescription.getId())) {
            Rectangle containerLabelFigureBounds = containerLabelFigure.getBounds();
            this.paintTitleBlockOnLabel(graphics, containerLabelFigureBounds);
        }
    }

    private void paintTitleBlockOnLabel(Graphics graphics, Rectangle label) {
        PointList pointList = this.getTitleBlockPointLists(label);
        if (pointList != null && pointList.size() != 0) {
            graphics.drawPolyline(pointList);
        }
    }

    private PointList getTitleBlockPointLists(Rectangle label) {
        PointList pointList = new PointList();
        LabelAlignment labelAlignment = this.getLabelAlignment();
        if (LabelAlignment.LEFT.equals((Object)labelAlignment)) {
            pointList.addAll(this.getSouthSide(label));
            pointList.addAll(this.getEastSide(label));
        } else if (LabelAlignment.CENTER.equals((Object)labelAlignment)) {
            pointList.addAll(this.getWestSide(label));
            pointList.addAll(this.getSouthSide(label));
            pointList.addAll(this.getEastSide(label));
        } else if (LabelAlignment.RIGHT.equals((Object)labelAlignment)) {
            pointList.addAll(this.getWestSide(label));
            pointList.addAll(this.getSouthSide(label));
        }
        return pointList;
    }

    private PointList getWestSide(Rectangle label) {
        int cornerHeight = this.labelBorderStyleDescription.getCornerHeight();
        int cornerWidth = this.labelBorderStyleDescription.getCornerWidth();
        PointList pointList = new PointList();
        pointList.addPoint(label.x - cornerWidth, label.y - 5);
        pointList.addPoint(label.x - cornerWidth, label.y + label.height + 5 - cornerHeight);
        pointList.addPoint(label.x - cornerWidth, label.y + label.height + 5 - cornerHeight);
        pointList.addPoint(label.x, label.y + label.height + 5);
        return pointList;
    }

    private PointList getSouthSide(Rectangle label) {
        PointList pointList = new PointList();
        pointList.addPoint(label.x, label.y + label.height + 5);
        pointList.addPoint(label.x + label.width, label.y + label.height + 5);
        return pointList;
    }

    private PointList getEastSide(Rectangle label) {
        int cornerHeight = this.labelBorderStyleDescription.getCornerHeight();
        int cornerWidth = this.labelBorderStyleDescription.getCornerWidth();
        PointList pointList = new PointList();
        pointList.addPoint(label.x + label.width, label.y + label.height + 5);
        pointList.addPoint(label.x + label.width + cornerWidth, label.y + label.height + 5 - cornerHeight);
        pointList.addPoint(label.x + label.width + cornerWidth, label.y + label.height + 5 - cornerHeight);
        pointList.addPoint(label.x + label.width + cornerWidth, label.y - 5);
        return pointList;
    }

    private Color geBorderColor() {
        RGBValues borderColor;
        if (this.viewNode.getStyle() instanceof BorderedStyle && (borderColor = ((BorderedStyle)this.viewNode.getStyle()).getBorderColor()) != null) {
            return new Color(null, borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue());
        }
        return ColorConstants.black;
    }

    public int getBorderWidth() {
        if (this.viewNode.getStyle() instanceof BorderedStyle) {
            return Math.max(((BorderedStyle)this.viewNode.getStyle()).getBorderSize(), 1);
        }
        return 1;
    }

    private LabelAlignment getLabelAlignment() {
        LabelAlignment alignment = (LabelAlignment)ViewpointPackage.eINSTANCE.getLabelStyle_LabelAlignment().getDefaultValue();
        if (this.viewNode.getStyle() instanceof LabelStyle) {
            alignment = ((LabelStyle)this.viewNode.getStyle()).getLabelAlignment();
        }
        return alignment;
    }
}

