/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.resource.AS2ID;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.LUSSIDs;
import org.eclipse.ocl.pivot.internal.resource.PivotSaveImpl;
import org.eclipse.ocl.pivot.internal.utilities.AS2XMIid;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.XMIUtil;

public class ASResourceImpl
extends XMIResourceImpl
implements ASResource {
    protected final @NonNull ASResourceFactory asResourceFactory;
    private @Nullable LUSSIDs lussids = null;
    private @Nullable Map<@NonNull String, @NonNull EObject> legacyXMIId2eObject = null;

    public ASResourceImpl(@NonNull URI uri, @NonNull ASResourceFactory asResourceFactory) {
        super(uri);
        this.asResourceFactory = asResourceFactory;
        assert (PivotUtilInternal.isASURI(uri));
    }

    public @Nullable EObject basicGetEObjectByID(@Nullable String id) {
        return this.idToEObjectMap != null ? (EObject)this.idToEObjectMap.get(id) : null;
    }

    public @Nullable LUSSIDs basicGetLUSSIDs() {
        return this.lussids;
    }

    protected XMLSave createXMLSave() {
        return new PivotSaveImpl((XMLHelper)new XMIHelperImpl((XMLResource)this){

            public String getHREF(EObject obj) {
                Property asProperty;
                if (obj instanceof Property && (asProperty = (Property)obj).isIsImplicit() && asProperty.getOpposite() != null) {
                    return null;
                }
                return super.getHREF(obj);
            }
        });
    }

    protected void doUnload() {
        super.doUnload();
        if (this.lussids != null) {
            this.resetLUSSIDs();
        }
    }

    @Override
    public @NonNull ASResourceFactory getASResourceFactory() {
        return this.asResourceFactory;
    }

    public Map<Object, Object> getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = XMIUtil.createSaveOptions();
        }
        return this.defaultSaveOptions;
    }

    protected EObject getEObjectByID(String id) {
        if (this.unloadingContents == null && this.idToEObjectMap == null) {
            AS2ID.assignIds(this, null);
        }
        if (this.idToEObjectMap == null) {
            return null;
        }
        EObject eObject = (EObject)this.idToEObjectMap.get(id);
        if (eObject != null) {
            return eObject;
        }
        if (this.isLoading()) {
            return null;
        }
        Map<@NonNull String, @NonNull EObject> legacyXMIId2eObject2 = this.legacyXMIId2eObject;
        if (legacyXMIId2eObject2 == null) {
            AS2XMIid as2id = new AS2XMIid();
            this.legacyXMIId2eObject = legacyXMIId2eObject2 = new HashMap<String, EObject>();
            for (EObject eObject2 : new TreeIterable((Resource)this)) {
                String legacyId;
                AS2XMIidVisitor idVisitor;
                Element element;
                Boolean status;
                if (!(eObject2 instanceof Element) || (status = (element = (Element)eObject2).accept(idVisitor = this.asResourceFactory.createAS2XMIidVisitor(as2id))) != Boolean.TRUE || (legacyId = idVisitor.toString()) == null) continue;
                legacyXMIId2eObject2.put(legacyId, eObject2);
            }
        }
        EObject eObject2 = legacyXMIId2eObject2.get(id);
        return eObject2;
    }

    public @NonNull LUSSIDs getLUSSIDs(@NonNull Map<@NonNull Object, @Nullable Object> options) {
        LUSSIDs lussids2 = this.lussids;
        if (lussids2 == null) {
            this.lussids = lussids2 = ((ASResourceFactory.ASResourceFactoryExtension)this.asResourceFactory).createLUSSIDs(this, options);
        }
        return lussids2;
    }

    @Override
    public @NonNull Model getModel() {
        EList contents = this.getContents();
        if (contents.size() <= 0) {
            throw new IllegalStateException("No Model at root of empty '" + this.getURI() + "'");
        }
        EObject eObject = (EObject)contents.get(0);
        if (!(eObject instanceof Model)) {
            throw new IllegalStateException("Non-Model at root of '" + this.getURI() + "'");
        }
        return (Model)eObject;
    }

    public String getURIFragment(EObject eObject) {
        if (this.unloadingContents == null && this.idToEObjectMap == null) {
            AS2ID.assignIds(this, null);
        }
        return super.getURIFragment(eObject);
    }

    public int getXmiidVersion() {
        for (EObject eRoot : this.getContents()) {
            Number xmiidVersion;
            if (!(eRoot instanceof Model) || (xmiidVersion = ((Model)eRoot).getXmiidVersion()) == null) continue;
            return xmiidVersion.intValue();
        }
        return 0;
    }

    public void resetLUSSIDs() {
        LUSSIDs lussids2 = this.lussids;
        this.lussids = null;
        if (lussids2 != null) {
            lussids2.dispose();
        }
    }

    public void setXmiidVersion(int xmiidVersion) {
        for (EObject eRoot : this.getContents()) {
            if (!(eRoot instanceof Model)) continue;
            ((Model)eRoot).setXmiidVersion(xmiidVersion);
        }
    }

    protected void unloaded(InternalEObject internalEObject) {
        if (internalEObject instanceof PivotObjectImpl) {
            ((PivotObjectImpl)internalEObject).unloaded(this);
        }
        super.unloaded(internalEObject);
    }

    protected boolean useIDAttributes() {
        return false;
    }

    protected boolean useIDs() {
        return true;
    }
}

