/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecoretools.design.ui.wizard.EcoreModelerWizard;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectEMFIProjectDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateDomainModelWizardContextAction {
    public CreateDomainModelAction actionToExecute = CreateDomainModelAction.CREATE_NEW_EMF_PROJECT;
    protected IProject gemocLanguageIProject = null;
    private IProject createdProject = null;

    public CreateDomainModelWizardContextAction(IProject updatedGemocLanguageProject) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
    }

    public void execute() {
        switch (this.actionToExecute) {
            case CREATE_NEW_EMF_PROJECT: {
                this.createNewEMFProject();
                break;
            }
            case SELECT_EXISTING_EMF_PROJECT: {
                this.selectExistingEMFProject();
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createNewEMFProject() {
        String wizardId = "org.eclipse.ecoretools.emf.design.wizardID";
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"org.eclipse.ecoretools.emf.design.wizardID");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    ((EcoreModelerWizard)wizard).setInitialProjectName(String.valueOf(XDSMLProjectHelper.baseProjectName((IProject)this.gemocLanguageIProject)) + ".model");
                    ((EcoreModelerWizard)wizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection());
                    WizardDialog wd = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res != 0) return;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    this.createdProject = workspaceListener.getLastCreatedProject();
                    if (this.createdProject == null) return;
                    this.addEMFProjectToConf(this.createdProject);
                    return;
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                }
                return;
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        } else {
            Activator.error("wizard with id=org.eclipse.ecoretools.emf.design.wizardID not found", null);
        }
    }

    protected void selectExistingEMFProject() {
        SelectEMFIProjectDialog dialog = new SelectEMFIProjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        int res = dialog.open();
        if (res == 0) {
            this.addEMFProjectToConf((IProject)dialog.getResult()[0]);
        }
    }

    protected void addEMFProjectToConf(IProject emfProject) {
        if (this.gemocLanguageIProject != null) {
            this.addEMFProjectToConf(emfProject, this.gemocLanguageIProject);
        }
    }

    protected void addEMFProjectToConf(IProject emfProject, IProject gemocProject) {
        ManifestChanger manifestChanger = new ManifestChanger(gemocProject);
        try {
            manifestChanger.addPluginDependency(emfProject.getName());
            manifestChanger.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCreatedEcoreUri() {
        if (this.createdProject != null) {
            FileFinderVisitor ecoreProjectVisitor = new FileFinderVisitor("ecore");
            try {
                this.createdProject.accept((IResourceVisitor)ecoreProjectVisitor);
                IFile ecoreIFile = ecoreProjectVisitor.getFile();
                if (ecoreIFile != null) {
                    return "platform:/resource" + ecoreIFile.getFullPath().toString();
                }
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
        }
        return "";
    }

    public static enum CreateDomainModelAction {
        CREATE_NEW_EMF_PROJECT,
        SELECT_EXISTING_EMF_PROJECT;

    }
}

