/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class PluginXMLHelper {
    public static final String PLUGIN_FILENAME = "plugin.xml";
    public static final String PLUGIN_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>";
    protected Document document;
    protected Element root;

    public static void createEmptyTemplateFile(IFile pluginXmlFile, boolean overrideIfExist) {
        if (overrideIfExist && pluginXmlFile.exists()) {
            try {
                pluginXmlFile.delete(true, null);
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
        }
        if (!pluginXmlFile.exists()) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(PLUGIN_TEMPLATE.getBytes());
                if (pluginXmlFile.exists()) {
                    pluginXmlFile.setContents((InputStream)stream, true, true, null);
                } else {
                    pluginXmlFile.create((InputStream)stream, true, null);
                }
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                Activator.error(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
        }
    }

    public void loadDocument(IFile pluginXmlFile) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            if (!pluginXmlFile.isSynchronized(0)) {
                pluginXmlFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            this.document = sxb.build(pluginXmlFile.getContents());
            this.root = this.document.getRootElement();
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public void saveDocument(IFile pluginXmlFile) {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            sortie.output(this.document, (OutputStream)stream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(stream.toByteArray());
            pluginXmlFile.setContents((InputStream)inputStream, 1, null);
        }
        catch (IOException e) {
            Activator.error(e.getMessage(), e);
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public Element updateXDSMLDefinitionInExtensionPoint(Element extensionPoint, String xDSMLName) {
        Element result;
        List elements = extensionPoint.getContent((Filter)new ElementFilter("XDSML_Definition"));
        if (elements.size() == 0) {
            result = new Element("XDSML_Definition");
            extensionPoint.addContent((Content)result);
        } else {
            result = (Element)elements.get(0);
        }
        result.setAttribute("name", xDSMLName);
        return result;
    }

    public Element updateXDSMLDefinitionAttributeInExtensionPoint(Element extensionPoint, String atributeName, String value) {
        Element result;
        List elements = extensionPoint.getContent((Filter)new ElementFilter("XDSML_Definition"));
        if (elements.size() == 0) {
            result = new Element("XDSML_Definition");
            extensionPoint.addContent((Content)result);
        } else {
            result = (Element)elements.get(0);
        }
        result.setAttribute(atributeName, value);
        return result;
    }

    public String getXDSMLDefinitionAttributeInExtensionPointValue(Element extensionPoint, String atributeName) {
        Element result;
        List elements = extensionPoint.getContent((Filter)new ElementFilter("XDSML_Definition"));
        if (elements.size() == 0) {
            result = new Element("XDSML_Definition");
            extensionPoint.addContent((Content)result);
        } else {
            result = (Element)elements.get(0);
        }
        return result.getAttributeValue(atributeName);
    }

    public Element getOrCreateExtensionPoint(String extensionPointName) {
        Element result;
        List elements = this.root.getContent((Filter)new ExtensionFilter(extensionPointName));
        if (elements.size() == 0) {
            result = new Element("extension");
            result.setAttribute("point", extensionPointName);
            this.root.addContent((Content)result);
        } else {
            result = (Element)elements.get(0);
        }
        return result;
    }

    public List<Element> getExtensionPoints(String extensionPointName) {
        return this.root.getContent((Filter)new ExtensionFilter(extensionPointName));
    }

    public String getXDSMLDefinitionAttribute(Element extensionPoint, String attributeName) {
        List elements = extensionPoint.getContent((Filter)new ElementFilter("XDSML_Definition"));
        if (!elements.isEmpty()) {
            return ((Element)elements.get(0)).getAttributeValue(attributeName);
        }
        return null;
    }

    public class ExtensionFilter
    extends ElementFilter {
        private static final long serialVersionUID = -1941823619643486082L;
        protected String extensionPointName;

        public ExtensionFilter(String extensionPointName) {
            super("extension");
            this.extensionPointName = extensionPointName;
        }

        public Element filter(Object content) {
            Element result = super.filter(content);
            if (result == null) {
                return null;
            }
            Attribute att = result.getAttribute("point");
            if (att == null) {
                return null;
            }
            if (att.getValue().equals(this.extensionPointName)) {
                return result;
            }
            return null;
        }
    }
}

