/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.gemoc.timeline.model.TimelineWindow;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;

public class Branch
implements Comparable<Branch> {
    private final TimelineWindow timelineWindow;
    private final int branch;

    public Branch(TimelineWindow timelineWindow, int branch) {
        this.timelineWindow = timelineWindow;
        this.branch = branch;
    }

    public int getBranch() {
        return this.branch;
    }

    public List<Choice> getChoices() {
        ArrayList<Choice> res = new ArrayList<Choice>();
        ITimelineProvider provider = this.getTimelineWindow().getProvider();
        int begin = Math.max(this.getTimelineWindow().getStart(), provider.getStart(this.branch));
        int end = Math.min(this.getTimelineWindow().getEnd(), provider.getEnd(this.branch));
        int index = begin;
        while (index < end) {
            res.add(new Choice(this.getTimelineWindow(), this.branch, index));
            ++index;
        }
        return res;
    }

    public TimelineWindow getTimelineWindow() {
        return this.timelineWindow;
    }

    public int hashCode() {
        return this.branch;
    }

    public boolean equals(Object obj) {
        return obj instanceof Branch && ((Branch)obj).branch == this.branch;
    }

    @Override
    public int compareTo(Branch otherBranch) {
        return this.getTimelineWindow().getProvider().getStart(this.branch) - otherBranch.getTimelineWindow().getProvider().getStart(otherBranch.branch);
    }
}

