/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.builder;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.NatureToggling;
import org.eclipse.gemoc.commons.eclipse.jdt.JavaProject;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.ui.PluginConverter;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleException;

public class AddRemoveGemocSequentialLanguageNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                try {
                    this.toggleNature(project);
                }
                catch (CoreException e) {
                    throw new ExecutionException("Failed to toggle nature", (Throwable)e);
                }
            }
        }
        return null;
    }

    private void toggleNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if ("org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.GemocSequentialLanguageNature".equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.GemocSequentialLanguageNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public void configureNature(IProject project) {
        try {
            NatureToggling result = IProjectUtils.toggleNature((IProject)project, (String)"org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.GemocSequentialLanguageNature");
            switch (result) {
                case Added: {
                    JavaProject.create((IProject)project);
                    this.addPluginNature(project);
                    this.addGemocNature(project);
                    this.updateManifestFile(project);
                    break;
                }
                case Removed: {
                    break;
                }
            }
        }
        catch (IOException | CoreException e) {
            Activator.error("Problem while adding Gemoc Language nature to project. " + e.getMessage(), e);
        }
    }

    private void addPluginNature(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            try {
                PluginXMLHelper.createEmptyTemplateFile((IFile)project.getFile("plugin.xml"), (boolean)false);
                PluginConverter.convert((IProject)project);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Activator.error("cannot add org.eclipse.pde.PluginNature nature to project due to " + e.getMessage(), e);
            }
        }
    }

    private void updateManifestFile(IProject project) {
        ManifestChanger changer = new ManifestChanger(project);
        try {
            changer.addPluginDependency("org.eclipse.gemoc.xdsmlframework.api", "0.1.0", true, true);
            changer.addPluginDependency("org.eclipse.emf.ecore.xmi", "2.8.0", true, true);
            changer.addPluginDependency("org.eclipse.gemoc.xdsmlframework.api");
            changer.addPluginDependency("org.eclipse.gemoc.execution.sequential.javaxdsml.api");
            changer.addPluginDependency("org.eclipse.gemoc.executionframework.engine");
            changer.commit();
        }
        catch (IOException | CoreException | BundleException e) {
            Activator.error("Failed to update manifest " + e.getMessage(), e);
        }
    }

    private void addGemocNature(IProject project) throws CoreException {
        AddRemoveGemocSequentialLanguageNatureHandler.addAsMainNature(project, "org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.GemocSequentialLanguageNature", null);
    }

    public static void addAsMainNature(IProject project, String natureID, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature(natureID)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = natureID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }
}

