/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher.tabs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.ConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher.tabs.LaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LaunchConfigurationAdvancedTab
extends LaunchConfigurationTab {
    protected Composite _parent;
    protected Text _timemodelLocationText;
    protected Button _isExhaustive;
    public int GRID_DEFAULT_WIDTH = 200;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            LaunchConfigurationAdvancedTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        this._parent = parent;
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        area.setLayout((Layout)gl);
        area.layout();
        this.setControl((Control)area);
        Group executionModelArea = this.createGroup(area, "execution model (.timemodel):");
        this.createModelLayout((Composite)executionModelArea, null);
        this._isExhaustive = this.createCheckButton(area, "Do Exhaustive Simulation");
        this._isExhaustive.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationAdvancedTab.this.setDirty(true);
                LaunchConfigurationAdvancedTab.this.updateLaunchConfigurationDialog();
                LaunchConfigurationAdvancedTab.this.getLaunchConfigurationDialog().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LaunchConfigurationAdvancedTab.this.setDirty(true);
                this.notifyAll();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", 1000);
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_DECIDER", "Step by step user decider");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ConcurrentRunConfiguration runConfiguration = new ConcurrentRunConfiguration(configuration);
            this._timemodelLocationText.setText(runConfiguration.getExecutionModelPath());
            this._isExhaustive.setSelection(runConfiguration.getIsExhaustiveSimulation());
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("TIMEMODEL_PATH", this._timemodelLocationText.getText());
        configuration.setAttribute("Do Exhaustive Simulation", this._isExhaustive.getSelection());
    }

    public String getName() {
        return "Advanced";
    }

    public Composite createModelLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Model to execute");
        this._timemodelLocationText = new Text(parent, 2052);
        this._timemodelLocationText.setLayoutData((Object)this.createStandardLayout());
        this._timemodelLocationText.setFont(font);
        this._timemodelLocationText.addModifyListener(this.fBasicModifyListener);
        Button modelLocationButton = this.createPushButton(parent, "Browse", null);
        modelLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAnyIFileDialog dialog = new SelectAnyIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationAdvancedTab.this._timemodelLocationText.setText(modelPath);
                    LaunchConfigurationAdvancedTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    private GridData createStandardLayout() {
        return new GridData(4, 0x1000000, true, false);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String timemodelName = this._timemodelLocationText.getText().trim();
        if (timemodelName.length() > 0) {
            IResource modelIResource = workspace.getRoot().findMember(timemodelName);
            if (modelIResource == null || !modelIResource.exists()) {
                this.setErrorMessage(NLS.bind((String)"execution model does not exist", (Object[])new String[]{timemodelName}));
                return false;
            }
            if (!timemodelName.equals("/")) {
                this.setWarningMessage("warning, you specified a specific timemodel file in the advanced tab... you may better know what you are doing :)");
            }
            if (!(modelIResource instanceof IFile)) {
                this.setErrorMessage(NLS.bind((String)"execution model invalid file", (Object[])new String[]{timemodelName}));
                return false;
            }
        }
        if (timemodelName.length() != 0) {
            this.setWarningMessage("warning, you specified a specific timemodel file in the advanced tab... you may better know what you are doing :)");
        }
        return true;
    }
}

