/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.timesquare.ccsl.IConstraint;
import fr.kairos.timesquare.ccsl.IDefinition;
import fr.kairos.timesquare.ccsl.ISpecification;
import fr.kairos.timesquare.ccsl.sat.IClock;
import fr.kairos.timesquare.ccsl.sat.IClockBuilder;
import fr.kairos.timesquare.ccsl.sat.INameToIntegerMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

final class ClockCollector
implements ISpecification,
Iterable<IClock>,
INameToIntegerMapper {
    private HashMap<String, Integer> namesToId = new HashMap();
    private ArrayList<IClock> clocks = new ArrayList();
    private ArrayList<String> names = new ArrayList();
    private IClockBuilder clockBuilder;

    ClockCollector(IClockBuilder clockBuilder) {
        this.clockBuilder = clockBuilder;
    }

    @Override
    public void addClock(String name) {
        Integer i = this.namesToId.get(name);
        if (i == null) {
            this.namesToId.put(name, this.clocks.size());
            this.clocks.add(this.clockBuilder.buildClock(name));
            this.names.add(name);
        }
    }

    @Override
    public void add(IConstraint constraint) {
        if (constraint instanceof IDefinition) {
            this.addClock(((IDefinition)constraint).getDefinedClock());
        }
    }

    @Override
    public boolean isConstraintSupported(String name) {
        return true;
    }

    @Override
    public Iterator<IClock> iterator() {
        return this.clocks.iterator();
    }

    @Override
    public int getIdFromName(String name) {
        Integer res = this.namesToId.get(name);
        if (res == null) {
            return -1;
        }
        return res;
    }

    IClock nameToClock(String name) {
        return this.idToClock(this.namesToId.get(name));
    }

    IClock idToClock(int id) {
        return this.clocks.get(id);
    }

    @Override
    public String getNameFromId(int id) {
        return this.names.get(id);
    }

    @Override
    public boolean hasName(String name) {
        return this.namesToId.containsKey(name);
    }

    @Override
    public int size() {
        return this.names.size();
    }
}

