/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import fr.inria.diverse.k3.al.annotationprocessor.Helper;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.services.TypeLookup;

/**
 * Comparator for MethodDeclaration
 */
@SuppressWarnings("all")
public class SortMethod implements Comparator<MethodDeclaration> {
  private TypeLookup context;
  
  public SortMethod(final TypeLookup context) {
    this.context = context;
  }
  
  @Override
  public int compare(final MethodDeclaration arg0, final MethodDeclaration arg2) {
    final ArrayList<ClassDeclaration> ext = new ArrayList<ClassDeclaration>();
    final ArrayList<ClassDeclaration> ext1 = new ArrayList<ClassDeclaration>();
    TypeDeclaration _declaringType = arg2.getDeclaringType();
    Helper.getSuperClass(ext1, ((ClassDeclaration) _declaringType), this.context);
    TypeDeclaration _declaringType_1 = arg0.getDeclaringType();
    Helper.getSuperClass(ext, ((ClassDeclaration) _declaringType_1), this.context);
    boolean _contains = ext.contains(arg2.getDeclaringType());
    if (_contains) {
      return (-1);
    } else {
      boolean _contains_1 = ext1.contains(arg0.getDeclaringType());
      if (_contains_1) {
        return 1;
      } else {
        return 0;
      }
    }
  }
}
