/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.comment.StatusCommentCommand;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class MarkerFactory {
    private Polyline _marker = null;
    private Polyline _marker2 = null;
    private Polygon _timepolygone = null;
    private Label _time = new Label();
    private IVcdDiagram _vdt;
    private VcdColorPreferences _mca;
    private int _oldfirable = -1;
    private int _oldmarker = -1;

    public MarkerFactory(ListConnections list, IVcdDiagram vdt) {
        this._vdt = vdt;
        this._mca = vdt.getColorPreferences();
        vdt.getVcdFactory().setMarkerFactory(this);
    }

    public void hideMarkerFireable() {
        if (this._oldfirable != -1) {
            this.showFireable(this._oldfirable);
        }
        if (this._oldmarker != -1) {
            this.showMarker(this._oldmarker, 0);
        }
    }

    public void showFireable(int x) {
        int height = this._vdt.getCanvas().getContents().getSize().height;
        for (Object obj : this._vdt.getNames().getContents().getChildren()) {
            if (!(obj instanceof RectangleFigure)) continue;
            RectangleFigure rf = (RectangleFigure)obj;
            Label l = (Label)rf.getChildren().get(0);
            l.setForegroundColor(this._mca.colorWhiteText());
        }
        if (x == this._oldfirable) {
            this._oldfirable = -1;
            return;
        }
        this._oldfirable = x;
        Object oldfig = null;
        int y = 0;
        while (y < height) {
            IFigure fig = this._vdt.getCanvas().getContents().findFigureAt(x, y);
            if (oldfig == null || !oldfig.equals(fig)) {
                Description descr = this._vdt.getVcdFactory().getFigureForDescription(fig);
                String clockName = "";
                if (descr != null) {
                    for (StatusCommentCommand cc : this._vdt.getVcdModel().getStatusCommentCommand()) {
                        if (cc.getTime() != descr.getTime() - this._vdt.getVcdModel().getPulse()) continue;
                        for (IVar var : this._vdt.getTraceCollector().getSelectedClocks()) {
                            if (!var.getIdentiferCode().equals(cc.getIdent())) continue;
                            clockName = var.getName();
                            break;
                        }
                        for (IVar obj : this._vdt.getNames().getContents().getChildren()) {
                            RectangleFigure rf;
                            Label l;
                            if (!(obj instanceof RectangleFigure) || !(l = (Label)(rf = (RectangleFigure)obj).getChildren().get(0)).getText().equals(clockName)) continue;
                            l.setForegroundColor(this._mca.colorDarkGreenGhostFireable());
                        }
                        clockName = "";
                    }
                    if (clockName.equals("")) {
                        clockName = descr.getName();
                        for (StatusCommentCommand obj : this._vdt.getNames().getContents().getChildren()) {
                            RectangleFigure rf;
                            Label l;
                            if (!(obj instanceof RectangleFigure) || !(l = (Label)(rf = (RectangleFigure)obj).getChildren().get(0)).getText().equals(clockName)) continue;
                            l.setForegroundColor(this._mca.colorLightGreenFirable());
                        }
                    }
                    oldfig = fig;
                }
            }
            ++y;
        }
    }

    public void showMarker(int x, int xscroll) {
        int factor = 1;
        double zoom = this._vdt.getMarkerZoom();
        double value = 1.0;
        value = (double)(x - 5 + xscroll) / zoom * (double)factor;
        value = Math.round(value / 10.0) * 10L;
        if (this._vdt.getVcdModel().getTimeScaleCommand() != null) {
            factor = this._vdt.getVcdModel().getTimeScaleCommand().getNumber();
        }
        if (this._marker != null) {
            this.remove((IFigure)this._vdt.getVcdFactory().getBackPanel(), (IFigure)this._marker);
            this.remove((IFigure)this._vdt.getVcdFactory().getScalePanel(), (IFigure)this._marker2);
            this.remove((IFigure)this._vdt.getVcdFactory().getScalePanel(), (IFigure)this._timepolygone);
            if ((int)value == this._oldmarker) {
                this._oldmarker = -1;
                this._marker = null;
                this._marker2 = null;
                this._timepolygone = null;
                return;
            }
        }
        this._oldmarker = (int)value;
        double exate_x = Math.round(value / 10.0);
        exate_x = exate_x * 10.0 * zoom + 5.0 - (double)xscroll;
        this._time.setText(this._vdt.getVcdModel().getTimeLabelling().getTimeMarker(value));
        this._time.setForegroundColor(this._mca.colorRedTime());
        this._time.setOpaque(true);
        this._time.setBounds(new Rectangle((int)exate_x, 0, 200, 20));
        this._marker = this.VerticalLine(this._mca.colorRedTimeXor(), new Point((int)exate_x + xscroll, 0), new Point((int)exate_x + xscroll, 1000));
        this._marker.setOutlineXOR(true);
        this._marker.setLineWidth(1);
        this._timepolygone = new Polygon();
        this._timepolygone.setOpaque(false);
        this._timepolygone.setLayoutManager((LayoutManager)new BorderLayout());
        this._timepolygone.setForegroundColor(this._mca.colorBlack());
        this._timepolygone.setPoints(new PointList());
        this._timepolygone.addPoint(new Point((int)exate_x + xscroll + 2, 30));
        this._timepolygone.addPoint(new Point((int)exate_x + xscroll + 150, 30));
        this._timepolygone.addPoint(new Point((int)exate_x + xscroll + 150, 50));
        this._timepolygone.addPoint(new Point((int)exate_x + xscroll + 2, 50));
        this._timepolygone.add((IFigure)this._time, (Object)BorderLayout.LEFT);
        this._marker2 = this.VerticalLine(this._mca.colorRedTime(), new Point((int)exate_x + xscroll, 30), new Point((int)exate_x + xscroll, 50));
        this.remove(this._vdt.getScaleCanvas().getContents(), (IFigure)this._time);
        this._vdt.getCanvas().layout();
        this._vdt.getVcdFactory().getBackPanel().add((IFigure)this._marker);
        this._vdt.getVcdFactory().getScalePanel().add((IFigure)this._marker2);
        this._vdt.getScaleCanvas().getContents().add((IFigure)this._timepolygone);
    }

    private void remove(IFigure content, IFigure remove) {
        if (content.getChildren().contains(remove)) {
            content.remove(remove);
        }
    }

    private Polyline VerticalLine(Color color, Point p1, Point p2) {
        Polyline pl = new Polyline();
        pl.addPoint(p1);
        pl.addPoint(p2);
        pl.setForegroundColor(color);
        return pl;
    }
}

