/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.comment;

import fr.inria.aoste.timesquare.utils.extensionpoint.ExtensionPointManager;
import fr.inria.aoste.timesquare.utils.extensionpoint.IExtensionManager;
import fr.inria.aoste.timesquare.vcd.model.comment.IDecodeComment;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;

public class DecodeDictionary
implements IExtensionManager {
    private static DecodeDictionary _decode;
    private HashMap<String, InfoComment> _hmsdc = new HashMap();

    public static final synchronized DecodeDictionary getDefault() {
        if (_decode == null) {
            _decode = new DecodeDictionary();
        }
        return _decode;
    }

    private DecodeDictionary() {
        ExtensionPointManager.findAllExtensions((IExtensionManager)this);
        this.disp();
    }

    public final String getExtensionPointName() {
        return "fr.inria.aoste.timesquare.vcd.vcdPE";
    }

    public final String getPluginName() {
        return "fr.inria.aoste.timesquare.vcd";
    }

    public IDecodeComment getDecoder(String s) {
        try {
            if (s == null) {
            }
            if (this._hmsdc == null) {
            }
            InfoComment ic = this._hmsdc.get(s.toLowerCase());
            if (ic == null) {
            }
            return ic.idc;
        }
        finally {
            return null;
        }
    }

    public void initExtension(IConfigurationElement ice) throws Throwable {
        Class icdclass = ExtensionPointManager.getPointExtensionClass((IConfigurationElement)ice, (String)"class", IDecodeComment.class);
        String pragma = ice.getAttribute("pragma");
        InfoComment ifc = new InfoComment(pragma, (IDecodeComment)icdclass.newInstance());
        IConfigurationElement[] iConfigurationElementArray = ice.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ice2 = iConfigurationElementArray[n2];
            this.attribute(ice2, ifc.lslc);
            ++n2;
        }
        this._hmsdc.put(pragma, ifc);
    }

    private void attribute(IConfigurationElement ice, ArrayList<LinkComment> allkc) {
        String s = ice.getName();
        LinkComment lk = LinkComment.valueOf(s);
        if (lk != null) {
            allkc.add(lk);
        }
    }

    public boolean isClockExtension(String id) {
        InfoComment ifc = this._hmsdc.get(id.toLowerCase());
        return ifc.lslc.contains((Object)LinkComment.clock);
    }

    public boolean isTimeExtension(String id) {
        InfoComment ifc = this._hmsdc.get(id.toLowerCase());
        return ifc.lslc.contains((Object)LinkComment.time);
    }

    public int addPragma(String s, IDecodeComment _idc, LinkComment[] alk) {
        InfoComment ifc = new InfoComment(s, _idc);
        LinkComment[] linkCommentArray = alk;
        int n = alk.length;
        int n2 = 0;
        while (n2 < n) {
            LinkComment lk = linkCommentArray[n2];
            ifc.lslc.add(lk);
            ++n2;
        }
        this._hmsdc.put(s, ifc);
        return 0;
    }

    private void disp() {
        System.out.println("VCD comment " + Integer.toHexString(this.hashCode()));
        for (String s : this._hmsdc.keySet()) {
            System.out.println("\t" + s + ": " + this._hmsdc.get(s).toString());
        }
    }

    private static class InfoComment {
        private String name;
        private IDecodeComment idc;
        ArrayList<LinkComment> lslc = new ArrayList();

        InfoComment(String name, IDecodeComment idc) {
            this.name = name;
            this.idc = idc;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            try {
                sb.append(" ").append(this.idc.getClass().getName());
                String separator = " [";
                for (LinkComment lk : this.lslc) {
                    sb.append(separator);
                    sb.append((Object)lk);
                    separator = ", ";
                }
                sb.append("]");
            }
            catch (Throwable e) {
                sb.append("!!");
            }
            return sb.toString();
        }
    }

    public static enum LinkComment {
        clock,
        all,
        tick,
        global,
        time;

    }
}

