/*---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *--------------------------------------------------------------------------------------------*/
/* GENERATED FILE, DO NOT MODIFY MANUALLY */

package org.eclipse.gemoc.protocols.eaop.api.data;

import com.google.gson.annotations.SerializedName
import java.util.Map
import org.eclipse.lsp4j.generator.JsonRpcData
import org.eclipse.lsp4j.jsonrpc.messages.Either
import org.eclipse.lsp4j.jsonrpc.validation.NonNull

/** Declaration of data classes and enum for the EngineAddonProtocolData.
	Auto-generated from json schema. Do not edit manually.
*/

@JsonRpcData
class EngineAboutToStartEventArguments  {
	/** The name of the engine that is will start */
	// @NonNull
	ExecutionEngineDto engine;
}
// undefined

@JsonRpcData
class EngineStartedEventArguments  {
	/** The name of the started engine */
	// @NonNull
	ExecutionEngineDto engine;
}
// undefined

@JsonRpcData
class EngineInitializedEventArguments  {
	/** The name of the initialized engine */
	// @NonNull
	ExecutionEngineDto engine;
}
// undefined

@JsonRpcData
class EngineAboutToStopEventArguments  {
	/** The name of the engine */
	// @NonNull
	ExecutionEngineDto engine;
}
// undefined

@JsonRpcData
class EngineStoppedEventArguments  {
	/** The name of the engine */
	// @NonNull
	ExecutionEngineDto engine;
}
// undefined

@JsonRpcData
class EngineAboutToDisposeEventArguments  {
	/** The name of the engine */
	// @NonNull
	ExecutionEngineDto engine;
}
// undefined

@JsonRpcData
class AboutToExecuteStepEventArguments  {
	/** The name of the engine */
	ExecutionEngineDto engine;
	/** step that is about to execute */
	StepDto stepToExecute;
}
// undefined
// undefined

@JsonRpcData
class StepExecutedEventArguments  {
	/** The name of the engine */
	ExecutionEngineDto engine;
	/** step executed */
	StepDto stepToExecute;
}
// undefined
// undefined

/** Arguments for 'Initialize' request. */
@JsonRpcData
class InitializeArguments  {
	/** Regular expression of the engineId of the engine(s) this client is controling/monitoring. (optional, default is '.*') */
	String engineIdRegExp;
}
// String

@JsonRpcData
class InitializeResponse  {
}

/** Arguments for 'getState' request. */
@JsonRpcData
class GetStateArguments  {
	/** ID or URI of the State */
	// @NonNull
	String stateId;
}
// String

@JsonRpcData
class GetStateResponse  {
	StateDto state;
}
// undefined

/** Arguments for 'getStep' request. */
@JsonRpcData
class GetStepArguments  {
	/** ID or URI of the Step */
	// @NonNull
	String stateId;
}
// String

@JsonRpcData
class GetStepResponse  {
	StepDto step;
}
// undefined

/** Information about the Execution Engine. */
@JsonRpcData
class ExecutionEngineDto  {
	/** The engine kind name. */
	String engineKindName;
	/** The engine name. */
	String engineName;
}
// String
// String

/** Information about a Step. */
@JsonRpcData
class StepDto  {
	MSEOccurenceDto mseOccurence;
	/** ID (typically an URI) of the starting RTD state (ie. before this step) */
	String startingStateID;
	/** ID (typically an URI) of the ending RTD state (ie. after this step) */
	String endingStateID;
}
// undefined
// String
// String

/** Information about a MSEOccurence. */
@JsonRpcData
class MSEOccurenceDto  {
	MSEDto mse;
	/** TODO ! */
	String parameters;
	/** TODO ! */
	String result;
}
// undefined
// String
// String

/** Information about a MSE. */
@JsonRpcData
class MSEDto  {
	/** URI of the caller EObject in the model */
	String callerEObjectURI;
	/** ID of the action applied to the EObject. Typically the URI of the EOperation. */
	String actionID;
}
// String
// String

/** Information about a State. NOTE: version working as diff between previous steps (StartedStep) / next steps (EndedSteps) */
@JsonRpcData
class StateDto  {
	StateValueDto[] changedValues;
	/** List of ID (or URI) of the steps that have this state as StartingState */
	String[] startedStepsID;
	/** List of ID (or URI) of the steps that have this state as EndingState */
	String[] endedStepsID;
}
// TODO deal with array propertytype for changedValues
// TODO deal with array propertytype for startedStepsID
// TODO deal with array propertytype for endedStepsID

/** Information about a StateValue. */
@JsonRpcData
class StateValueDto  {
}

/** A structured message object. Used to return errors from requests. */
@JsonRpcData
class Message  {
	/** Unique identifier for the message. */
	// @NonNull
	Integer id;
	/** A format string for the message. Embedded variables have the form '{name}'.
		If variable name starts with an underscore character, the variable does not contain user data (PII) and can be safely used for telemetry purposes.
	*/
	// @NonNull
	String format;
	/** An object used as a dictionary for looking up the variables in the format string. */
	Map<String, String> variables;
	/** If true send to telemetry. */
	boolean sendTelemetry;
	/** If true show user. */
	boolean showUser;
	/** An optional url where additional information about this message can be found. */
	String url;
	/** An optional label that is presented to the user as the UI for opening the url. */
	String urlLabel;
}
// Integer
// String
// TODO deal with object propertytype for variables
// boolean
// boolean
// String
// String

