/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.ui;

import java.io.File;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenEditor {
    public static void openManifestForProject(IProject project) {
        File fileToOpen = new File(project.getFile("META-INF/MANIFEST.MF").getLocation().toOSString());
        if (fileToOpen.exists() && fileToOpen.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    public static void openIFile(IFile iFile) {
        File fileToOpen = new File(iFile.getLocation().toOSString());
        OpenEditor.openFile(fileToOpen);
    }

    public static void openFile(File file) {
        if (file.exists() && file.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    public static void openPossibleFileWithExtensionInProject(IProject project, String fileExtension) {
        FileFinderVisitor finder = new FileFinderVisitor(fileExtension);
        try {
            project.accept((IResourceVisitor)finder);
            List list = finder.getFiles();
            if (list.size() == 1) {
                OpenEditor.openIFile((IFile)list.get(0));
            } else {
                OpenEditor.openPossibleFileInProject(project, "*." + fileExtension);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    public static void openPossibleFileInProject(IProject project, String searchedFilePattern) {
        SelectAnyIFileDialog fileFinderDialog = new SelectAnyIFileDialog((IContainer)project);
        fileFinderDialog.setPattern(searchedFilePattern);
        if (fileFinderDialog.open() == 0) {
            OpenEditor.openIFile((IFile)fileFinderDialog.getResult()[0]);
        }
    }
}

