/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelectorService;
import org.eclipse.sirius.diagram.ui.edit.api.part.DesignerEditPartHelper;
import org.eclipse.sirius.diagram.ui.tools.api.migration.DiagramCrossReferencer;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.IDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.Identifier;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.Style;

public abstract class AbstractDiagramElementState<D extends DDiagramElement>
implements IDiagramElementState<D> {
    protected DiagramCrossReferencer crossReferencer;
    protected boolean isVisible;
    protected boolean isHidden;
    protected boolean isLabelHidden;
    protected List<Node> nodes = new ArrayList<Node>();
    protected List<Edge> edges = new ArrayList<Edge>();
    private boolean isExplictlyFolded;
    private boolean isIndirectlyFold;
    private final Identifier identifier;
    private Map<Identifier, Map<String, Object>> customizableToCustomizedFeatures = new HashMap<Identifier, Map<String, Object>>();
    private List<AbsoluteBoundsFilter> boundsFilters;
    private Dimension expandedDimension;

    public AbstractDiagramElementState(Identifier id, DiagramCrossReferencer crossReferencer) {
        this.identifier = id;
        this.crossReferencer = crossReferencer;
        this.boundsFilters = new ArrayList<AbsoluteBoundsFilter>();
    }

    @Override
    public void dispose() {
        this.nodes.clear();
        this.edges.clear();
        this.customizableToCustomizedFeatures.clear();
    }

    @Override
    public void storeElementState(EObject target, DiagramElementMapping mapping, D element) {
        GraphicalFilter graphicalFilter;
        Iterable flags;
        this.customizableToCustomizedFeatures.clear();
        this.isVisible = element.isVisible();
        DDiagramElementQuery dDiagramElementQuery = new DDiagramElementQuery(element);
        this.isHidden = dDiagramElementQuery.isHidden();
        this.isLabelHidden = dDiagramElementQuery.isLabelHidden();
        this.storeFold(element);
        for (Map.Entry reference : this.crossReferencer.entrySet()) {
            if (!((EObject)reference.getKey()).equals(element)) continue;
            List valueList = (List)reference.getValue();
            int i = 0;
            while (i < valueList.size()) {
                EStructuralFeature.Setting nextNodeSetting = (EStructuralFeature.Setting)valueList.get(i);
                if (nextNodeSetting.getEObject() instanceof Node) {
                    this.nodes.add((Node)nextNodeSetting.getEObject());
                } else {
                    this.edges.add((Edge)nextNodeSetting.getEObject());
                }
                ++i;
            }
        }
        Style ownedStyle = element.getStyle();
        if (ownedStyle != null) {
            this.storeStyleCustomizations((Customizable)ownedStyle);
        }
        if (!Iterables.isEmpty((Iterable)(flags = Iterables.filter((Iterable)element.getGraphicalFilters(), AbsoluteBoundsFilter.class)))) {
            Iterables.addAll(this.boundsFilters, (Iterable)flags);
        }
        Predicate<Object> predicate = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof CollapseFilter && ((CollapseFilter)input).eIsSet((EStructuralFeature)DiagramPackage.eINSTANCE.getCollapseFilter_Height()) && ((CollapseFilter)input).eIsSet((EStructuralFeature)DiagramPackage.eINSTANCE.getCollapseFilter_Width());
            }
        };
        Iterable elementCollapseFilters = Iterables.filter((Iterable)element.getGraphicalFilters(), (Predicate)predicate);
        if (!Iterables.isEmpty((Iterable)elementCollapseFilters) && (graphicalFilter = (GraphicalFilter)Iterables.get((Iterable)elementCollapseFilters, (int)0)) instanceof CollapseFilter) {
            this.expandedDimension = new Dimension(((CollapseFilter)graphicalFilter).getWidth(), ((CollapseFilter)graphicalFilter).getHeight());
        }
    }

    private void storeStyleCustomizations(Customizable customizable) {
        HashMap<String, Object> customFeatures = new HashMap<String, Object>();
        for (String featureName : customizable.getCustomFeatures()) {
            EStructuralFeature structuralFeature = customizable.eClass().getEStructuralFeature(featureName);
            if (structuralFeature == null) continue;
            Object value = customizable.eGet(structuralFeature);
            if (value instanceof Collection) {
                value = Lists.newArrayList((Iterable)((Collection)value));
            }
            customFeatures.put(featureName, value);
        }
        Identifier customizableIdentifier = Identifier.createCustomizableIdentifier(customizable);
        if (customizableIdentifier != null && !customFeatures.isEmpty()) {
            this.customizableToCustomizedFeatures.put(customizableIdentifier, customFeatures);
        }
        TreeIterator iterator = customizable.eAllContents();
        while (iterator.hasNext()) {
            EObject currentObject = (EObject)iterator.next();
            if (!(currentObject instanceof Customizable)) continue;
            this.storeStyleCustomizations((Customizable)currentObject);
        }
    }

    protected void storeFold(D element) {
        DDiagramElementQuery query = new DDiagramElementQuery(element);
        this.isExplictlyFolded = query.isExplicitlyFolded();
        this.isIndirectlyFold = query.isIndirectlyFolded();
    }

    @Override
    public void restoreElementState(D element) {
        if (this.isHidden) {
            HideFilterHelper.INSTANCE.hide(element);
        } else {
            HideFilterHelper.INSTANCE.reveal(element);
        }
        if (this.isLabelHidden) {
            HideFilterHelper.INSTANCE.hideLabel(element);
        } else {
            HideFilterHelper.INSTANCE.revealLabel(element);
        }
        element.setVisible(this.isVisible);
        if (this.isExplictlyFolded) {
            this.addFilterType((DDiagramElement)element, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingPointFilter());
        }
        if (this.isIndirectlyFold) {
            this.addFilterType((DDiagramElement)element, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingFilter());
        }
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).setElement(element);
            if (element instanceof DNode) {
                for (Object next : this.nodes.get(i).getChildren()) {
                    Node node;
                    if (!(next instanceof Node) || !this.isStyle(node = (Node)next)) continue;
                    node.setElement((EObject)((DNode)element).getOwnedStyle());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            this.edges.get(i).setElement(element);
            ++i;
        }
        if (!this.boundsFilters.isEmpty()) {
            element.getGraphicalFilters().addAll(this.boundsFilters);
        }
        Iterable elementCollapseFilters = Iterables.filter((Iterable)element.getGraphicalFilters(), CollapseFilter.class);
        for (CollapseFilter currentCollapseFilter : elementCollapseFilters) {
            if (this.expandedDimension == null) continue;
            currentCollapseFilter.setWidth(this.expandedDimension.width);
            currentCollapseFilter.setHeight(this.expandedDimension.height);
        }
        Style ownedStyle = element.getStyle();
        if (ownedStyle != null) {
            this.restoreCustomFeatures((Customizable)ownedStyle);
        }
    }

    private void restoreCustomFeatures(Customizable customizable) {
        Customizable currentCustomizable = customizable;
        Identifier customizableIdentifier = Identifier.createCustomizableIdentifier(currentCustomizable);
        Map<String, Object> customizedFeatures = this.customizableToCustomizedFeatures.get(customizableIdentifier);
        if (customizedFeatures != null) {
            if (this.isWorkspaceImageStyleSetedByUser(currentCustomizable, customizedFeatures)) {
                Object object = customizedFeatures.get(DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName());
                EObject eContainer = currentCustomizable.eContainer();
                EReference eContainmentFeature = currentCustomizable.eContainmentFeature();
                if (object instanceof String && currentCustomizable instanceof BasicLabelStyle && eContainer != null && eContainmentFeature != null) {
                    ImageSelectorService.INSTANCE.updateStyle((BasicLabelStyle)currentCustomizable, (String)object);
                    currentCustomizable = (Customizable)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                }
            }
            for (Map.Entry entry : customizedFeatures.entrySet()) {
                String featureName = (String)entry.getKey();
                Object value = entry.getValue();
                EStructuralFeature eStructuralFeature = currentCustomizable.eClass().getEStructuralFeature(featureName);
                if (eStructuralFeature == null) continue;
                currentCustomizable.eSet(eStructuralFeature, value);
                currentCustomizable.getCustomFeatures().add((Object)eStructuralFeature.getName());
            }
        }
        TreeIterator treeIterator = currentCustomizable.eAllContents();
        while (treeIterator.hasNext()) {
            EObject currentObject = (EObject)treeIterator.next();
            if (!(currentObject instanceof Customizable)) continue;
            this.restoreCustomFeatures((Customizable)currentObject);
        }
    }

    private boolean isWorkspaceImageStyleSetedByUser(Customizable customizable, Map<String, Object> customizedFeatures) {
        boolean isWorkspaceImageStyleSetedByUser = customizedFeatures.keySet().contains(DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName()) && !(customizable instanceof WorkspaceImage);
        return isWorkspaceImageStyleSetedByUser;
    }

    private boolean isStyle(Node node) {
        String typeStr = node.getType();
        int type = -1;
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (NumberFormatException numberFormatException) {}
        return DesignerEditPartHelper.isNodeStyle(type);
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    protected void addFilterType(DDiagramElement element, GraphicalFilter filter) {
        if (!Iterables.any((Iterable)element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(filter.getClass()))) {
            element.getGraphicalFilters().add((Object)filter);
        }
    }
}

