/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.inject.Inject;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @deprecated We now use EMF's generator for model types. This shouldn't be
 * used anymore.
 */
@SuppressWarnings("all")
public class EnumInferrer {
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private NamingHelper _namingHelper;
  
  /**
   * Mimic the EMF generator for EEnum.
   * Clearly not a nice solution.
   */
  public void generateEnum(final ModelType mt, final EEnum enu, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    final Procedure1<JvmEnumerationType> _function = new Procedure1<JvmEnumerationType>() {
      @Override
      public void apply(final JvmEnumerationType it) {
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _typeRef = builder.typeRef(Enumerator.class);
        EnumInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
        final Consumer<EEnumLiteral> _function = new Consumer<EEnumLiteral>() {
          @Override
          public void accept(final EEnumLiteral lit) {
            EList<JvmMember> _members = it.getMembers();
            final Procedure1<JvmEnumerationLiteral> _function = new Procedure1<JvmEnumerationLiteral>() {
              @Override
              public void apply(final JvmEnumerationLiteral it) {
              }
            };
            JvmEnumerationLiteral _enumerationLiteral = EnumInferrer.this._jvmTypesBuilder.toEnumerationLiteral(mt, lit.getName().toUpperCase(), _function);
            EnumInferrer.this._jvmTypesBuilder.<JvmEnumerationLiteral>operator_add(_members, _enumerationLiteral);
            EList<JvmMember> _members_1 = it.getMembers();
            String _upperCase = lit.getName().toUpperCase();
            String _plus = (_upperCase + "_VALUE");
            final Procedure1<JvmField> _function_1 = new Procedure1<JvmField>() {
              @Override
              public void apply(final JvmField it) {
                it.setStatic(true);
                it.setFinal(true);
                it.setVisibility(JvmVisibility.PUBLIC);
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    int _value = lit.getValue();
                    _builder.append(_value);
                  }
                };
                EnumInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
              }
            };
            JvmField _field = EnumInferrer.this._jvmTypesBuilder.toField(mt, _plus, builder.typeRef(int.class), _function_1);
            EnumInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members_1, _field);
          }
        };
        enu.getELiterals().forEach(_function);
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmField> _function_1 = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("new ");
                String _name = enu.getName();
                _builder.append(_name);
                _builder.append("[] {");
                _builder.newLineIfNotEmpty();
                {
                  EList<EEnumLiteral> _eLiterals = enu.getELiterals();
                  for(final EEnumLiteral lit : _eLiterals) {
                    _builder.append("\t");
                    String _upperCase = lit.getName().toUpperCase();
                    _builder.append(_upperCase, "\t");
                    _builder.append(",");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("};");
                _builder.newLine();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
          }
        };
        JvmField _field = EnumInferrer.this._jvmTypesBuilder.toField(mt, "VALUES_ARRAY", EnumInferrer.this._jvmTypesBuilder.addArrayTypeDimension(builder.typeRef(it)), _function_1);
        EnumInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members, _field);
        EList<JvmMember> _members_1 = it.getMembers();
        final Procedure1<JvmField> _function_2 = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Collections.class);
                _builder.append(".unmodifiableList(");
                _builder.append(Arrays.class);
                _builder.append(".asList(VALUES_ARRAY));");
                _builder.newLineIfNotEmpty();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
          }
        };
        JvmField _field_1 = EnumInferrer.this._jvmTypesBuilder.toField(mt, "VALUES", builder.typeRef(List.class, builder.typeRef(it)), _function_2);
        EnumInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members_1, _field_1);
        EList<JvmMember> _members_2 = it.getMembers();
        final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = EnumInferrer.this._jvmTypesBuilder.toParameter(mt, "literal", builder.typeRef(String.class));
            EnumInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("for (int i = 0; i < VALUES_ARRAY.length; ++i) {");
                _builder.newLine();
                _builder.append("\t");
                String _name = enu.getName();
                _builder.append(_name, "\t");
                _builder.append(" result = VALUES_ARRAY[i];");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (result.toString().equals(literal)) {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.append("return null;");
                _builder.newLine();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "get", builder.typeRef(EnumInferrer.this._namingHelper.getFqnFor(mt, enu)), _function_3);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method);
        EList<JvmMember> _members_3 = it.getMembers();
        final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = EnumInferrer.this._jvmTypesBuilder.toParameter(mt, "name", builder.typeRef(String.class));
            EnumInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("for (int i = 0; i < VALUES_ARRAY.length; ++i) {");
                _builder.newLine();
                _builder.append("\t");
                String _name = enu.getName();
                _builder.append(_name, "\t");
                _builder.append(" result = VALUES_ARRAY[i];");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (result.getName().equals(name)) {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.append("return null;");
                _builder.newLine();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_1 = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "getByName", builder.typeRef(EnumInferrer.this._namingHelper.getFqnFor(mt, enu)), _function_4);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_1);
        EList<JvmMember> _members_4 = it.getMembers();
        final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = EnumInferrer.this._jvmTypesBuilder.toParameter(mt, "value", builder.typeRef(int.class));
            EnumInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            final ArrayList<Integer> values = CollectionLiterals.<Integer>newArrayList();
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("switch (value) {");
                _builder.newLine();
                {
                  EList<EEnumLiteral> _eLiterals = enu.getELiterals();
                  for(final EEnumLiteral lit : _eLiterals) {
                    {
                      boolean _contains = values.contains(Integer.valueOf(lit.getValue()));
                      boolean _not = (!_contains);
                      if (_not) {
                        _builder.append("\t");
                        _builder.append("/* ");
                        int _value = lit.getValue();
                        boolean _add = values.add(Integer.valueOf(_value));
                        _builder.append(_add, "\t");
                        _builder.append(" */");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("case ");
                        String _upperCase = lit.getName().toUpperCase();
                        _builder.append(_upperCase, "\t");
                        _builder.append("_VALUE: return ");
                        String _upperCase_1 = lit.getName().toUpperCase();
                        _builder.append(_upperCase_1, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.append("}");
                _builder.newLine();
                _builder.append("return null;");
                _builder.newLine();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_2 = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "get", builder.typeRef(EnumInferrer.this._namingHelper.getFqnFor(mt, enu)), _function_5);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_2);
        EList<JvmMember> _members_5 = it.getMembers();
        final Procedure1<JvmField> _function_6 = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setFinal(true);
          }
        };
        JvmField _field_2 = EnumInferrer.this._jvmTypesBuilder.toField(mt, "value", builder.typeRef(int.class), _function_6);
        EnumInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members_5, _field_2);
        EList<JvmMember> _members_6 = it.getMembers();
        final Procedure1<JvmField> _function_7 = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setFinal(true);
          }
        };
        JvmField _field_3 = EnumInferrer.this._jvmTypesBuilder.toField(mt, "name", builder.typeRef(String.class), _function_7);
        EnumInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members_6, _field_3);
        EList<JvmMember> _members_7 = it.getMembers();
        final Procedure1<JvmField> _function_8 = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setFinal(true);
          }
        };
        JvmField _field_4 = EnumInferrer.this._jvmTypesBuilder.toField(mt, "literal", builder.typeRef(String.class), _function_8);
        EnumInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members_7, _field_4);
        EList<JvmMember> _members_8 = it.getMembers();
        final Procedure1<JvmConstructor> _function_9 = new Procedure1<JvmConstructor>() {
          @Override
          public void apply(final JvmConstructor it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("this.value = 0;");
                _builder.newLine();
                _builder.append("this.name = \"\";");
                _builder.newLine();
                _builder.append("this.literal = \"\";");
                _builder.newLine();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmConstructor _constructor = EnumInferrer.this._jvmTypesBuilder.toConstructor(mt, _function_9);
        EnumInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members_8, _constructor);
        EList<JvmMember> _members_9 = it.getMembers();
        final Procedure1<JvmConstructor> _function_10 = new Procedure1<JvmConstructor>() {
          @Override
          public void apply(final JvmConstructor it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = EnumInferrer.this._jvmTypesBuilder.toParameter(mt, "value", builder.typeRef(int.class));
            EnumInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter_1 = EnumInferrer.this._jvmTypesBuilder.toParameter(mt, "name", builder.typeRef(String.class));
            EnumInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
            EList<JvmFormalParameter> _parameters_2 = it.getParameters();
            JvmFormalParameter _parameter_2 = EnumInferrer.this._jvmTypesBuilder.toParameter(mt, "literal", builder.typeRef(String.class));
            EnumInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("this.value = value;");
                _builder.newLine();
                _builder.append("this.name = name;");
                _builder.newLine();
                _builder.append("this.literal = literal;");
                _builder.newLine();
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmConstructor _constructor_1 = EnumInferrer.this._jvmTypesBuilder.toConstructor(mt, _function_10);
        EnumInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members_9, _constructor_1);
        EList<JvmMember> _members_10 = it.getMembers();
        final Procedure1<JvmOperation> _function_11 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return name;");
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_3 = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "getName", builder.typeRef(String.class), _function_11);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_10, _method_3);
        EList<JvmMember> _members_11 = it.getMembers();
        final Procedure1<JvmOperation> _function_12 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return value;");
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_4 = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "getValue", builder.typeRef(int.class), _function_12);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_11, _method_4);
        EList<JvmMember> _members_12 = it.getMembers();
        final Procedure1<JvmOperation> _function_13 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return literal;");
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_5 = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "getLiteral", builder.typeRef(String.class), _function_13);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_12, _method_5);
        EList<JvmMember> _members_13 = it.getMembers();
        final Procedure1<JvmOperation> _function_14 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return literal;");
              }
            };
            EnumInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_6 = EnumInferrer.this._jvmTypesBuilder.toMethod(mt, "toString", builder.typeRef(String.class), _function_14);
        EnumInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_13, _method_6);
      }
    };
    acceptor.<JvmEnumerationType>accept(
      this._jvmTypesBuilder.toEnumerationType(mt, this._namingHelper.getFqnFor(mt, enu), _function));
  }
}
