/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.metamodel.melange.ClassBinding;
import fr.inria.diverse.melange.metamodel.melange.PackageBinding;
import fr.inria.diverse.melange.metamodel.melange.PropertyBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Utilities related to renaming facilities associated to {@link Operator}s.
 */
@SuppressWarnings("all")
public class RenamerHelper {
  @Inject
  @Extension
  private EcoreExtensions _ecoreExtensions;
  
  /**
   * Apply the renaming rules of {@code mappingRules} to the {@link EPackage}s,
   * {@link EClassifier}s and {@link EStructuralFeature}s of {@code modelRoot}.
   */
  public void applyRenaming(final EPackage modelRoot, final List<PackageBinding> mappingRules) {
    boolean _isEmpty = mappingRules.isEmpty();
    if (_isEmpty) {
      return;
    }
    final Consumer<PackageBinding> _function = new Consumer<PackageBinding>() {
      @Override
      public void accept(final PackageBinding packageRule) {
        EPackage _xifexpression = null;
        String _name = modelRoot.getName();
        String _from = packageRule.getFrom();
        boolean _equals = Objects.equal(_name, _from);
        if (_equals) {
          _xifexpression = modelRoot;
        } else {
          String _from_1 = packageRule.getFrom();
          int _indexOf = packageRule.getFrom().indexOf(".");
          int _plus = (_indexOf + 1);
          _xifexpression = RenamerHelper.this._ecoreExtensions.findSubPackage(modelRoot, 
            _from_1.substring(_plus));
        }
        final EPackage sourcePkg = _xifexpression;
        final Consumer<ClassBinding> _function = new Consumer<ClassBinding>() {
          @Override
          public void accept(final ClassBinding classRule) {
            EList<EClassifier> _eClassifiers = null;
            if (sourcePkg!=null) {
              _eClassifiers=sourcePkg.getEClassifiers();
            }
            Iterable<EClass> _filter = null;
            if (_eClassifiers!=null) {
              _filter=Iterables.<EClass>filter(_eClassifiers, EClass.class);
            }
            Iterable<EClass> _filter_1 = null;
            if (_filter!=null) {
              final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
                @Override
                public Boolean apply(final EClass it) {
                  String _name = it.getName();
                  String _from = classRule.getFrom();
                  return Boolean.valueOf(Objects.equal(_name, _from));
                }
              };
              _filter_1=IterableExtensions.<EClass>filter(_filter, _function);
            }
            if (_filter_1!=null) {
              final Consumer<EClass> _function_1 = new Consumer<EClass>() {
                @Override
                public void accept(final EClass cls) {
                  final Consumer<PropertyBinding> _function = new Consumer<PropertyBinding>() {
                    @Override
                    public void accept(final PropertyBinding propertyRule) {
                      EStructuralFeature _elvis = null;
                      final Function1<EReference, Boolean> _function = new Function1<EReference, Boolean>() {
                        @Override
                        public Boolean apply(final EReference it) {
                          String _name = it.getName();
                          String _from = propertyRule.getFrom();
                          return Boolean.valueOf(Objects.equal(_name, _from));
                        }
                      };
                      EReference _findFirst = IterableExtensions.<EReference>findFirst(cls.getEReferences(), _function);
                      if (_findFirst != null) {
                        _elvis = _findFirst;
                      } else {
                        final Function1<EAttribute, Boolean> _function_1 = new Function1<EAttribute, Boolean>() {
                          @Override
                          public Boolean apply(final EAttribute it) {
                            String _name = it.getName();
                            String _from = propertyRule.getFrom();
                            return Boolean.valueOf(Objects.equal(_name, _from));
                          }
                        };
                        EAttribute _findFirst_1 = IterableExtensions.<EAttribute>findFirst(cls.getEAttributes(), _function_1);
                        _elvis = _findFirst_1;
                      }
                      final EStructuralFeature target = _elvis;
                      if ((target != null)) {
                        target.setName(propertyRule.getTo());
                      }
                    }
                  };
                  classRule.getProperties().forEach(_function);
                  cls.setName(classRule.getTo());
                }
              };
              _filter_1.forEach(_function_1);
            }
          }
        };
        packageRule.getClasses().forEach(_function);
      }
    };
    mappingRules.forEach(_function);
    final String oldRootName = modelRoot.getName();
    final HashSet<EPackage> renamedPackages = CollectionLiterals.<EPackage>newHashSet();
    final HashSet<EPackage> targetedPackages = CollectionLiterals.<EPackage>newHashSet();
    final Consumer<PackageBinding> _function_1 = new Consumer<PackageBinding>() {
      @Override
      public void accept(final PackageBinding packageRule) {
        final String[] oldPackages = packageRule.getFrom().split("\\.");
        final String[] newPackages = packageRule.getTo().split("\\.");
        EPackage current = modelRoot;
        for (int i = 1; (i < ((List<String>)Conversions.doWrapArray(oldPackages)).size()); i++) {
          {
            final String packName = oldPackages[i];
            final Function1<EPackage, Boolean> _function = new Function1<EPackage, Boolean>() {
              @Override
              public Boolean apply(final EPackage it) {
                String _name = it.getName();
                return Boolean.valueOf(Objects.equal(_name, packName));
              }
            };
            current = IterableExtensions.<EPackage>findFirst(current.getESubpackages(), _function);
          }
        }
        renamedPackages.add(current);
        current = modelRoot;
        targetedPackages.add(current);
        for (int i = 1; (i < ((List<String>)Conversions.doWrapArray(newPackages)).size()); i++) {
          {
            final String packName = newPackages[i];
            final Function1<EPackage, Boolean> _function = new Function1<EPackage, Boolean>() {
              @Override
              public Boolean apply(final EPackage it) {
                String _name = it.getName();
                return Boolean.valueOf(Objects.equal(_name, packName));
              }
            };
            EPackage nextCurrent = IterableExtensions.<EPackage>findFirst(current.getESubpackages(), _function);
            if ((nextCurrent == null)) {
              nextCurrent = EcoreFactory.eINSTANCE.createEPackage();
              nextCurrent.setName(packName);
              nextCurrent.setNsPrefix(packName);
              String _nsURI = current.getNsURI();
              String _plus = (_nsURI + packName);
              String _plus_1 = (_plus + "/");
              nextCurrent.setNsURI(_plus_1);
              current.getESubpackages().add(nextCurrent);
            }
            current = nextCurrent;
            targetedPackages.add(current);
          }
        }
        String _head = IterableExtensions.<String>head(((Iterable<String>)Conversions.doWrapArray(newPackages)));
        String _name = modelRoot.getName();
        boolean _notEquals = (!Objects.equal(_head, _name));
        if (_notEquals) {
          modelRoot.setName(IterableExtensions.<String>head(((Iterable<String>)Conversions.doWrapArray(newPackages))));
        }
      }
    };
    mappingRules.forEach(_function_1);
    final HashBasedTable<EPackage, EPackage, ArrayList<EClassifier>> movedClasses = HashBasedTable.<EPackage, EPackage, ArrayList<EClassifier>>create();
    final HashBasedTable<EPackage, EPackage, ArrayList<EPackage>> movedPackages = HashBasedTable.<EPackage, EPackage, ArrayList<EPackage>>create();
    final Consumer<PackageBinding> _function_2 = new Consumer<PackageBinding>() {
      @Override
      public void accept(final PackageBinding packageRule) {
        EPackage _xifexpression = null;
        String _from = packageRule.getFrom();
        boolean _equals = Objects.equal(oldRootName, _from);
        if (_equals) {
          _xifexpression = modelRoot;
        } else {
          String _from_1 = packageRule.getFrom();
          int _indexOf = packageRule.getFrom().indexOf(".");
          int _plus = (_indexOf + 1);
          _xifexpression = RenamerHelper.this._ecoreExtensions.findSubPackage(modelRoot, 
            _from_1.substring(_plus));
        }
        final EPackage sourcePkg = _xifexpression;
        EPackage _xifexpression_1 = null;
        String _name = modelRoot.getName();
        String _to = packageRule.getTo();
        boolean _equals_1 = Objects.equal(_name, _to);
        if (_equals_1) {
          _xifexpression_1 = modelRoot;
        } else {
          String _to_1 = packageRule.getTo();
          int _indexOf_1 = packageRule.getTo().indexOf(".");
          int _plus_1 = (_indexOf_1 + 1);
          _xifexpression_1 = RenamerHelper.this._ecoreExtensions.findSubPackage(modelRoot, 
            _to_1.substring(_plus_1));
        }
        final EPackage targetPack = _xifexpression_1;
        if (((sourcePkg != null) && (!Objects.equal(sourcePkg, targetPack)))) {
          final ArrayList<EClassifier> classes = CollectionLiterals.<EClassifier>newArrayList();
          classes.addAll(sourcePkg.getEClassifiers());
          movedClasses.put(sourcePkg, targetPack, classes);
          final ArrayList<EPackage> subPackages = CollectionLiterals.<EPackage>newArrayList();
          subPackages.addAll(sourcePkg.getESubpackages());
          subPackages.removeAll(targetedPackages);
          subPackages.removeAll(renamedPackages);
          movedPackages.put(sourcePkg, targetPack, subPackages);
        }
      }
    };
    mappingRules.forEach(_function_2);
    final Consumer<Table.Cell<EPackage, EPackage, ArrayList<EClassifier>>> _function_3 = new Consumer<Table.Cell<EPackage, EPackage, ArrayList<EClassifier>>>() {
      @Override
      public void accept(final Table.Cell<EPackage, EPackage, ArrayList<EClassifier>> cell) {
        final EPackage sourcePkg = cell.getRowKey();
        final EPackage targetPack = cell.getColumnKey();
        final ArrayList<EClassifier> classes = cell.getValue();
        targetPack.getEClassifiers().addAll(classes);
        sourcePkg.getEClassifiers().remove(classes);
      }
    };
    movedClasses.cellSet().forEach(_function_3);
    final Consumer<Table.Cell<EPackage, EPackage, ArrayList<EPackage>>> _function_4 = new Consumer<Table.Cell<EPackage, EPackage, ArrayList<EPackage>>>() {
      @Override
      public void accept(final Table.Cell<EPackage, EPackage, ArrayList<EPackage>> cell) {
        final EPackage sourcePkg = cell.getRowKey();
        final EPackage targetPack = cell.getColumnKey();
        final ArrayList<EPackage> subPackages = cell.getValue();
        targetPack.getESubpackages().addAll(subPackages);
        sourcePkg.getESubpackages().remove(subPackages);
        boolean _contains = targetedPackages.contains(sourcePkg);
        boolean _not = (!_contains);
        if (_not) {
          sourcePkg.getESuperPackage().getESubpackages().remove(sourcePkg);
        }
      }
    };
    movedPackages.cellSet().forEach(_function_4);
  }
}
