/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.resource.merging;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.commons.eclipse.resource.merging.ActionContext;
import org.eclipse.gemoc.commons.eclipse.resource.merging.IBeforeSavingAction;
import org.eclipse.gemoc.commons.eclipse.resource.merging.ResourcesMergerContext;

public class ResourceMerger {
    private ResourcesMergerContext _context;

    protected ResourceMerger(ResourcesMergerContext context) {
        this._context = context;
    }

    public void merge() throws IOException {
        EList<Resource> resources = this.getResources();
        URI outputURI = URI.createPlatformResourceURI((String)this._context.getOutputFile().getFullPath().toString(), (boolean)true);
        this.merge(resources, outputURI);
    }

    private EList<Resource> getResources() {
        ResourceSetImpl rs = new ResourceSetImpl();
        URI inputURI = URI.createPlatformResourceURI((String)this._context.getInputFile().getFullPath().toString(), (boolean)true);
        Resource r = rs.getResource(inputURI, true);
        EcoreUtil.resolveAll((Resource)r);
        EcoreUtil.resolveAll((ResourceSet)rs);
        return rs.getResources();
    }

    private void merge(EList<Resource> resources, URI outputURI) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource uniqueResource = rs.createResource(outputURI);
        for (Resource r : resources) {
            uniqueResource.getContents().addAll((Collection)r.getContents());
        }
        for (IBeforeSavingAction action : this._context.getBeforeSavingActions()) {
            ActionContext c = new ActionContext(uniqueResource);
            action.run(c);
        }
        uniqueResource.save(null);
    }
}

