/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AntlrAstToAleBehaviorsFactory;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AstVisitors;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;

public class AntlrAstToBehaviorsAstAdapter {
    private IQueryEnvironment qryEnv;

    public AntlrAstToBehaviorsAstAdapter(IQueryEnvironment qryEnv) {
        this.qryEnv = qryEnv;
        AntlrAstToAleBehaviorsFactory.createSingleton(qryEnv);
    }

    public List<ParsedFile<ModelUnit>> toBehaviors(List<ALEParser.RRootContext> antlrASTs, Map<ALEParser.RRootContext, String> sourceFiles) {
        ArrayList<ParsedFile<ModelUnit>> build = new ArrayList<ParsedFile<ModelUnit>>();
        Map<String, List<EClass>> allNewClasses = this.createNewEClassesFromDynamicClasses(antlrASTs);
        this.buildClassExtensions(antlrASTs, sourceFiles, build);
        this.updateDeclaredEClassDefinitions(build, allNewClasses);
        List<ExtendedClass> allExtensions = this.resolveExtends(build);
        this.resolveOpposites(build, allExtensions);
        return build;
    }

    private Map<String, List<EClass>> createNewEClassesFromDynamicClasses(List<ALEParser.RRootContext> antlrASTs) {
        HashMap<String, List<EClass>> allNewClasses = new HashMap<String, List<EClass>>();
        antlrASTs.stream().forEach(sourceFileAST -> {
            List<EClass> newOnes = AstVisitors.preVisit(sourceFileAST);
            EPackage candidatePkg = null;
            Collection pkgs = this.qryEnv.getEPackageProvider().getEPackage(sourceFileAST.rQualified().getText());
            candidatePkg = pkgs != null && !pkgs.isEmpty() ? (EPackage)pkgs.iterator().next() : AntlrAstToAleBehaviorsFactory.singleton.buildEPackage(sourceFileAST.rQualified().getText());
            candidatePkg.getEClassifiers().addAll(newOnes);
            String behaviorName = sourceFileAST.rQualified().getText();
            allNewClasses.put(behaviorName, newOnes);
            EPackage topPkg = candidatePkg;
            while (topPkg.getESuperPackage() != null) {
                topPkg = topPkg.getESuperPackage();
            }
            this.qryEnv.removeEPackage(topPkg);
            this.qryEnv.registerEPackage(topPkg);
        });
        return allNewClasses;
    }

    private void buildClassExtensions(List<ALEParser.RRootContext> rawParses, Map<ALEParser.RRootContext, String> sourceFiles, List<ParsedFile<ModelUnit>> build) {
        rawParses.stream().forEach(p -> {
            ParsedFile<ModelUnit> parseRes = AstVisitors.visit(p);
            parseRes.setSourceFile((String)sourceFiles.get(p));
            build.add(parseRes);
        });
    }

    private void updateDeclaredEClassDefinitions(List<ParsedFile<ModelUnit>> build, Map<String, List<EClass>> allNewClasses) {
        build.stream().map(m -> (ModelUnit)m.getRoot()).filter(m -> m != null).forEach(implemModel -> {
            List newClasses = (List)allNewClasses.get(implemModel.getName());
            if (newClasses != null) {
                implemModel.getClassDefinitions().stream().forEach(clsDef -> {
                    Optional<EClass> cls = newClasses.stream().filter(c -> c.getName().equals(clsDef.getName())).findFirst();
                    if (cls.isPresent()) {
                        AntlrAstToAleBehaviorsFactory.singleton.updateEClass(cls.get(), (RuntimeClass)clsDef);
                    }
                });
            }
        });
    }

    private List<ExtendedClass> resolveExtends(List<ParsedFile<ModelUnit>> build) {
        HashMap behaviorToClass = new HashMap();
        ArrayList<ExtendedClass> allExtensions = new ArrayList<ExtendedClass>();
        build.stream().forEach(sem -> {
            ModelUnit root = (ModelUnit)sem.getRoot();
            if (root != null) {
                List xtdCls = root.getClassExtensions().stream().collect(Collectors.toList());
                behaviorToClass.put(root.getName(), xtdCls);
                allExtensions.addAll(xtdCls);
            }
        });
        allExtensions.stream().forEach(cls -> {
            List toResolve = cls.getEAnnotations().stream().filter(a -> a.getSource().equals("http://org/eclipse/emf/ecoretools/ale/parser/metadata")).filter(a -> a.getDetails().get((Object)"extends") != null).collect(Collectors.toList());
            toResolve.stream().forEach(annot -> {
                Optional<ExtendedClass> searchRes;
                int lastDot;
                String xtd = (String)annot.getDetails().get((Object)"extends");
                String qualifying = ((ModelUnit)cls.eContainer()).getName();
                String name = xtd;
                if (AstVisitors.isQualified(xtd) && (lastDot = xtd.lastIndexOf(".")) < xtd.length()) {
                    qualifying = xtd.substring(0, lastDot);
                    name = xtd.substring(lastDot + 1);
                }
                String finalName = name;
                List candidates = (List)behaviorToClass.get(qualifying);
                if (candidates != null && (searchRes = candidates.stream().filter(c -> c.getBaseClass().getName().equals(finalName)).findFirst()).isPresent()) {
                    cls.getExtends().add((Object)searchRes.get());
                    cls.getEAnnotations().remove(annot);
                }
            });
        });
        return allExtensions;
    }

    private void resolveOpposites(List<ParsedFile<ModelUnit>> build, List<ExtendedClass> allExtensions) {
        ArrayList allAttributes = new ArrayList();
        build.stream().forEach(sem -> {
            ModelUnit root = (ModelUnit)sem.getRoot();
            if (root != null) {
                root.getClassExtensions().stream().forEach(cls -> allAttributes.addAll(cls.getAttributes()));
                root.getClassDefinitions().stream().forEach(cls -> allAttributes.addAll(cls.getAttributes()));
            }
        });
        allAttributes.stream().filter(attr -> attr.getEAnnotation("http://org/eclipse/emf/ecoretools/ale/parser/metadata") != null).forEach(attr -> {
            EAnnotation annot = attr.getEAnnotation("http://org/eclipse/emf/ecoretools/ale/parser/metadata");
            String opposite = (String)annot.getDetails().get((Object)"opposite");
            EClassifier oppositeType = attr.getFeatureRef().getEType();
            if (oppositeType instanceof EClass) {
                Optional<Attribute> candidate;
                EClass oppositeClass = (EClass)oppositeType;
                EStructuralFeature oppositeFeature = oppositeClass.getEStructuralFeature(opposite);
                if (oppositeFeature == null && (candidate = allExtensions.stream().filter(xtd -> xtd.getBaseClass() == oppositeType).flatMap(xtd -> xtd.getAttributes().stream()).filter(a -> a.getFeatureRef().getName().equals(opposite)).findFirst()).isPresent()) {
                    oppositeFeature = candidate.get().getFeatureRef();
                }
                if (oppositeFeature instanceof EReference) {
                    ((EReference)attr.getFeatureRef()).setEOpposite((EReference)oppositeFeature);
                    attr.getEAnnotations().remove((Object)annot);
                }
            }
        });
    }
}

