/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.notapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class RuntimeInstanceHelper {
    public static final String ALE_RUNTIME = "ALE_RUNTIME_";
    public static final String ALE_RUNTIME_PKG = "ALE_RUNTIME_PKG";

    public static Map<EClass, EClass> getBaseToRuntime(List<ModelUnit> allModelUnits, List<EClass> domain) {
        HashMap<EClass, EClass> baseToRuntime = new HashMap<EClass, EClass>();
        HashMap baseToFragments = new HashMap();
        allModelUnits.stream().flatMap(u -> u.getClassExtensions().stream()).forEach(xtd -> {
            EClass base = xtd.getBaseClass();
            ArrayList fragments = (ArrayList)baseToFragments.get(base);
            if (fragments == null) {
                fragments = new ArrayList();
                baseToFragments.put(base, fragments);
            }
            ArrayList finalFrag = fragments;
            HashSet<ExtendedClass> allSupers = new HashSet<ExtendedClass>();
            RuntimeInstanceHelper.collectAllSupers(xtd, allSupers);
            allSupers.forEach(extension -> {
                if (extension.getFragment() != null) {
                    finalFrag.add(extension.getFragment());
                }
            });
        });
        domain.forEach(cls -> {
            if (baseToFragments.get(cls) == null) {
                baseToFragments.put(cls, new ArrayList());
            }
        });
        domain.forEach(cls -> baseToRuntime.put((EClass)cls, RuntimeInstanceHelper.merge(cls, RuntimeInstanceHelper.allFragments(cls, baseToFragments, domain))));
        EClass ePkgClass = EcorePackage.eINSTANCE.getEPackage();
        EPackage pkg = (EPackage)EcoreUtil.create((EClass)ePkgClass);
        pkg.setName(ALE_RUNTIME_PKG);
        baseToRuntime.values().forEach(cls -> {
            boolean bl = pkg.getEClassifiers().add(cls);
        });
        return baseToRuntime;
    }

    private static List<EClass> allSupers(EClass cls, List<EClass> domain) {
        return domain.stream().filter(c -> c.isSuperTypeOf(cls)).collect(Collectors.toList());
    }

    private static void collectAllSupers(ExtendedClass xtdCls, Set<ExtendedClass> collector) {
        if (!collector.contains(xtdCls)) {
            collector.add(xtdCls);
            EList<ExtendedClass> supers = xtdCls.getExtends();
            supers.forEach(s -> RuntimeInstanceHelper.collectAllSupers(s, collector));
        }
    }

    private static Set<EClass> allFragments(EClass baseClass, Map<EClass, List<EClass>> baseToFragments, List<EClass> domain) {
        List<EClass> allSuperClasses = RuntimeInstanceHelper.allSupers(baseClass, domain);
        return allSuperClasses.stream().flatMap(base -> ((List)baseToFragments.get(base)).stream()).collect(Collectors.toSet());
    }

    private static EClass merge(EClass base, Set<EClass> fragments) {
        EClass eClsClass = EcorePackage.eINSTANCE.getEClass();
        EClass cls = (EClass)EcoreUtil.create((EClass)eClsClass);
        cls.setName(ALE_RUNTIME + base.getName());
        fragments.stream().flatMap(frag -> frag.getEAllStructuralFeatures().stream()).forEach(feature -> {
            EStructuralFeature featureCopy = (EStructuralFeature)EcoreUtil.copy((EObject)feature);
            cls.getEStructuralFeatures().add((Object)featureCopy);
        });
        return cls;
    }
}

