/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.text.MessageFormat;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.query.IllegalStateExceptionQuery;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DRepresentationDescriptorQuery {
    private DRepresentationDescriptor repDescriptor;

    public DRepresentationDescriptorQuery(DRepresentationDescriptor repDescriptor) {
        this.repDescriptor = repDescriptor;
    }

    public boolean isDangling() {
        return this.repDescriptor.getTarget() == null || SessionManager.INSTANCE.getSession(this.repDescriptor.getTarget()) == null;
    }

    public boolean isRepresentationReachable() {
        boolean isRepresentationReachable = this.repDescriptor.isLoadedRepresentation();
        if (!isRepresentationReachable && this.repDescriptor.getRepPath() != null) {
            String extention = this.repDescriptor.getRepPath().getResourceURI().fileExtension();
            if ("aird".equals(extention)) {
                return this.repDescriptor.getRepresentation() != null;
            }
            Resource eResource = this.repDescriptor.eResource();
            if (eResource != null) {
                ResourceSet resourceSet = eResource.getResourceSet();
                try {
                    isRepresentationReachable = resourceSet.getURIConverter().exists(this.repDescriptor.getRepPath().getResourceURI(), null);
                }
                catch (RuntimeException e) {
                    SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DRepresentationDescriptorQuery_representationError, this.repDescriptor.getName(), this.repDescriptor.getRepPath(), this.repDescriptor.getUid()), e);
                }
            }
        }
        return isRepresentationReachable;
    }

    public boolean isRepresentationValid() {
        DRepresentationDescriptorValidityAdapter dRepDescriptorValidityAdapter = (DRepresentationDescriptorValidityAdapter)this.repDescriptor.eAdapters().stream().filter(DRepresentationDescriptorValidityAdapter.class::isInstance).findFirst().orElseGet(() -> new DRepresentationDescriptorValidityAdapter(this.repDescriptor));
        return dRepDescriptorValidityAdapter.isValid();
    }

    private boolean computeRepresentationValid() {
        try {
            boolean isValid;
            boolean bl = isValid = !this.isDangling() && this.isRepresentationReachable();
            if (isValid && this.repDescriptor.isLoadedRepresentation()) {
                isValid = !new DRepresentationQuery(this.repDescriptor.getRepresentation()).isDanglingRepresentation();
            }
            return isValid;
        }
        catch (IllegalStateException e) {
            if (new IllegalStateExceptionQuery(e).isAConnectionLostException()) {
                return false;
            }
            throw e;
        }
    }

    public class DRepresentationDescriptorValidityAdapter
    extends AdapterImpl
    implements Adapter {
        private boolean validity;

        public DRepresentationDescriptorValidityAdapter(DRepresentationDescriptor representationDescriptor) {
            representationDescriptor.eAdapters().add((Object)this);
            this.validity = DRepresentationDescriptorQuery.this.computeRepresentationValid();
        }

        public void triggerRepresentationValidation() {
            this.validity = DRepresentationDescriptorQuery.this.computeRepresentationValid();
        }

        public boolean isValid() {
            return this.validity;
        }

        public void notifyChanged(Notification notification) {
        }
    }
}

