/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.migration;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.viewpoint.Messages;
import org.osgi.framework.Version;

public class ResourceVersionMismatchDiagnostic
implements Resource.Diagnostic {
    private final URI resourceToLoadURI;
    private Version lastMigrationVersion;
    private Version parsedLoadedVersion;

    public ResourceVersionMismatchDiagnostic(URI resourceToLoadURI, Version parsedLoadedVersion, Version lastMigrationVersion) {
        this.resourceToLoadURI = resourceToLoadURI;
        this.lastMigrationVersion = lastMigrationVersion;
        this.parsedLoadedVersion = parsedLoadedVersion;
    }

    public Version getLastMigrationVersion() {
        return this.lastMigrationVersion;
    }

    public Version getParsedLoadedVersion() {
        return this.parsedLoadedVersion;
    }

    public URI getResourceToLoadURI() {
        return this.resourceToLoadURI;
    }

    public String getLocation() {
        if (this.resourceToLoadURI != null) {
            return this.resourceToLoadURI.toString();
        }
        return null;
    }

    public int getLine() {
        return 0;
    }

    public int getColumn() {
        return 0;
    }

    public String getMessage() {
        String message = null;
        String fileExtension = this.resourceToLoadURI.fileExtension();
        if ("aird".equals(fileExtension)) {
            message = MessageFormat.format(Messages.ResourceVersionMismatchDiagnostic_airdMessage, this.resourceToLoadURI, this.parsedLoadedVersion, this.lastMigrationVersion);
        } else if ("odesign".equals(fileExtension)) {
            message = MessageFormat.format(Messages.ResourceVersionMismatchDiagnostic_vsmMessage, this.resourceToLoadURI, this.parsedLoadedVersion, this.lastMigrationVersion);
        }
        return message;
    }
}

