/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleWebResource;

final class BundleWebResourceAttributes {
    private static final long TIME_NOT_SET = -1L;
    private static final int CREATION_DATE_UNKNOWN = 0;
    private static final long CONTENT_LENGTH_NOT_SET = -1L;
    private final BundleWebResource resource;
    private long lastModified = -1L;
    private long creation = -1L;
    private long contentLength = -1L;

    BundleWebResourceAttributes(BundleWebResource resource) {
        this.resource = resource;
        URLConnection urlConnection = this.getURLConnection();
        if (urlConnection != null) {
            this.getLastModified(urlConnection);
            this.getCreation(urlConnection);
            this.getContentLength(urlConnection);
        }
    }

    long getContentLength(URLConnection urlConnection) {
        if (this.contentLength == -1L) {
            if (urlConnection == null) {
                urlConnection = this.getURLConnection();
            }
            if (urlConnection != null) {
                this.contentLength = this.determineContentLength(urlConnection);
            }
        }
        return this.contentLength;
    }

    long getCreation(URLConnection urlConnection) {
        if (this.creation == -1L) {
            if (urlConnection == null) {
                urlConnection = this.getURLConnection();
            }
            if (urlConnection != null) {
                this.creation = urlConnection.getDate();
                if (this.creation == 0L) {
                    if (this.lastModified == -1L) {
                        this.lastModified = urlConnection.getLastModified();
                    }
                    this.creation = this.lastModified;
                }
            }
        }
        return this.creation;
    }

    long getLastModified(URLConnection urlConnection) {
        if (this.lastModified == -1L) {
            if (urlConnection == null) {
                urlConnection = this.getURLConnection();
            }
            if (urlConnection != null) {
                this.lastModified = urlConnection.getLastModified();
            }
        }
        return this.lastModified;
    }

    private URLConnection getURLConnection() {
        try {
            URL url = this.resource.getURL();
            if (url != null) {
                return url.openConnection();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private long determineContentLength(URLConnection urlConnection) {
        long size = this.resource.resolveBundleWebResourceSize();
        if (size == -1L && urlConnection != null) {
            size = urlConnection.getContentLength();
        }
        return size;
    }
}

