/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.eclipse.gemini.naming.InvocationHandlerFactory;
import org.eclipse.gemini.naming.OSGiURLParser;
import org.eclipse.gemini.naming.SecurityUtils;
import org.eclipse.gemini.naming.ServiceInvocationHandler;
import org.eclipse.gemini.naming.ServiceProxyInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ReflectionUtils {
    private static Logger logger = Logger.getLogger(ReflectionUtils.class.getName());

    ReflectionUtils() {
    }

    static Object invokeMethodOnContext(Method method, Context contextToInvokeOn, Object[] args) throws Throwable {
        return ReflectionUtils.invokeMethodOnObject(method, contextToInvokeOn, args);
    }

    static Object invokeMethodOnObject(Method method, Object objectToInvokeOn, Object[] args) throws IllegalAccessException, Throwable {
        try {
            return method.invoke(objectToInvokeOn, args);
        }
        catch (InvocationTargetException invocationException) {
            throw invocationException.getTargetException();
        }
    }

    static ServiceProxyInfo getProxyForSingleService(BundleContext bundleContext, OSGiURLParser urlParser, ServiceReference serviceReference) {
        return ReflectionUtils.getProxyForSingleService(bundleContext, urlParser, serviceReference, new RetryInvocationHandlerFactory());
    }

    static ServiceProxyInfo getProxyForSingleService(BundleContext bundleContext, OSGiURLParser urlParser, ServiceReference serviceReference, InvocationHandlerFactory handlerFactory) {
        final Object requestedService = bundleContext.getService(serviceReference);
        ClassLoader tempLoader = null;
        try {
            tempLoader = (ClassLoader)SecurityUtils.invokePrivilegedAction(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return requestedService.getClass().getClassLoader();
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception occurred while trying to obtain OSGi service's ClassLoader", e);
        }
        try {
            Class<?> clazz = Class.forName(urlParser.getServiceInterface(), true, tempLoader);
            if (clazz.isInterface()) {
                InvocationHandler handler = handlerFactory.create(bundleContext, serviceReference, urlParser, requestedService);
                Object serviceProxy = Proxy.newProxyInstance(tempLoader, new Class[]{clazz}, handler);
                return new ServiceProxyInfo(serviceProxy, handler, true);
            }
            logger.log(Level.WARNING, "The service type " + clazz.getName() + " is not an interface.  The Gemini Naming implementation cannot generate a proxy for this service.");
            return new ServiceProxyInfo(requestedService, null, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            tempLoader = requestedService.getClass().getClassLoader();
            Class[] interfaces = ReflectionUtils.getInterfaces(serviceReference, bundleContext, tempLoader);
            if (interfaces.length > 0) {
                InvocationHandler handler = handlerFactory.create(bundleContext, serviceReference, urlParser, requestedService);
                Object serviceProxy = Proxy.newProxyInstance(tempLoader, interfaces, handler);
                return new ServiceProxyInfo(serviceProxy, handler, true);
            }
            logger.log(Level.WARNING, "No compatible interfaces could be found for this OSGi service, type = " + requestedService.getClass().getName() + ".  The Gemini Naming implementation cannot generate a proxy for this service.");
            throw new IllegalArgumentException("No compatible interfaces could be found for this OSGi service, type = " + urlParser.getServiceInterface() + " (probably a JNDI Service Name)" + ".  The Gemini Naming implementation cannot generate a proxy for this service.");
        }
    }

    private static boolean isAssignable(ServiceReference serviceReference, BundleContext bundleContext, Class clazz) {
        return serviceReference.isAssignableTo(bundleContext.getBundle(), clazz.getName());
    }

    private static boolean isInterfacePublic(Class clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    private static Class[] getInterfaces(ServiceReference serviceReference, BundleContext bundleContext, ClassLoader classLoader) {
        String[] objectClassValues = (String[])serviceReference.getProperty("objectClass");
        LinkedList listOfClasses = new LinkedList();
        int i = 0;
        while (i < objectClassValues.length) {
            try {
                Class<?> clazz = Class.forName(objectClassValues[i], true, classLoader);
                if (clazz.isInterface()) {
                    if (ReflectionUtils.isInterfacePublic(clazz)) {
                        if (ReflectionUtils.isAssignable(serviceReference, bundleContext, clazz)) {
                            listOfClasses.add(clazz);
                        }
                    } else {
                        logger.warning("Unable to generate proxy for non-public interface: " + clazz.getName() + ".  This interface will not be available to clients");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++i;
        }
        if (listOfClasses.isEmpty()) {
            return new Class[0];
        }
        Class[] interfacesToReturn = new Class[listOfClasses.size()];
        int i2 = 0;
        while (i2 < listOfClasses.size()) {
            interfacesToReturn[i2] = (Class)listOfClasses.get(i2);
            ++i2;
        }
        return interfacesToReturn;
    }

    private static class RetryInvocationHandlerFactory
    implements InvocationHandlerFactory {
        private RetryInvocationHandlerFactory() {
        }

        @Override
        public InvocationHandler create(BundleContext bundleContext, ServiceReference serviceReference, OSGiURLParser urlParser, Object osgiService) {
            return new ServiceInvocationHandler(bundleContext, serviceReference, urlParser, osgiService);
        }
    }
}

