/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.framework.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.Item;
import org.osgi.jmx.framework.ServiceStateMBean;

public final class OSGiService {
    private long bundle;
    private long identifier;
    private String[] interfaces;
    private Long[] usingBundles;

    public OSGiService(ServiceReference<?> reference) {
        this.identifier = (Long)reference.getProperty("service.id");
        this.interfaces = (String[])reference.getProperty("objectClass");
        this.bundle = reference.getBundle().getBundleId();
        this.usingBundles = this.longArrayFrom(OSGiService.getBundlesUsing(reference));
    }

    private Long[] longArrayFrom(long[] array) {
        if (array == null) {
            return new Long[0];
        }
        Long[] result = new Long[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static long[] getBundlesUsing(ServiceReference<?> serviceRef) {
        Bundle[] bundles = serviceRef.getUsingBundles();
        if (bundles == null) {
            return new long[0];
        }
        long[] ids = new long[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            ids[i] = bundles[i].getBundleId();
            ++i;
        }
        return ids;
    }

    public static TabularData tableFrom(List<OSGiService> services) {
        TabularDataSupport table = new TabularDataSupport(ServiceStateMBean.SERVICES_TYPE);
        for (OSGiService service : services) {
            table.put(service.asCompositeData());
        }
        return table;
    }

    public static TabularData tableFrom(List<OSGiService> services, String ... serviceTypeItems) throws IOException {
        List<String> serviceTypes = Arrays.asList(serviceTypeItems);
        TabularDataSupport table = new TabularDataSupport(Item.tabularType((String)"SERVICES", (String)"The table of all services", (CompositeType)OSGiService.computeServiceType(serviceTypes), (String[])new String[]{"Identifier"}));
        for (OSGiService service : services) {
            table.put(service.asCompositeData(serviceTypes));
        }
        return table;
    }

    private static CompositeType computeServiceType(List<String> serviceTypes) {
        ArrayList<Item> serviceTypeItems = new ArrayList<Item>();
        serviceTypeItems.add(ServiceStateMBean.IDENTIFIER_ITEM);
        if (serviceTypes.contains("objectClass")) {
            serviceTypeItems.add(ServiceStateMBean.OBJECT_CLASS_ITEM);
        }
        if (serviceTypes.contains("BundleIdentifier")) {
            serviceTypeItems.add(ServiceStateMBean.BUNDLE_IDENTIFIER_ITEM);
        }
        if (serviceTypes.contains("UsingBundles")) {
            serviceTypeItems.add(ServiceStateMBean.USING_BUNDLES_ITEM);
        }
        CompositeType currentCompositeType = Item.compositeType((String)"SERVICE", (String)"This type encapsulates an OSGi service", (Item[])serviceTypeItems.toArray(new Item[0]));
        return currentCompositeType;
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.identifier);
        items.put("objectClass", this.interfaces);
        items.put("BundleIdentifier", this.bundle);
        items.put("UsingBundles", this.usingBundles);
        try {
            return new CompositeDataSupport(ServiceStateMBean.SERVICE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service open data", e);
        }
    }

    private CompositeData asCompositeData(List<String> serviceTypes) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        if (serviceTypes.contains("Identifier")) {
            items.put("Identifier", this.identifier);
        }
        if (serviceTypes.contains("objectClass")) {
            items.put("objectClass", this.interfaces);
        }
        if (serviceTypes.contains("BundleIdentifier")) {
            items.put("BundleIdentifier", this.bundle);
        }
        if (serviceTypes.contains("UsingBundles")) {
            items.put("UsingBundles", this.usingBundles);
        }
        try {
            return new CompositeDataSupport(ServiceStateMBean.SERVICE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service open data", e);
        }
    }
}

