/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.service;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.IGraphLayoutEngine;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.service.LayoutInfoService;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EclipseLayoutInfoService
extends LayoutInfoService
implements IAdapterFactory {
    public static final String EXTP_ID_LAYOUT_MANAGERS = "de.cau.cs.kieler.kiml.ui.layoutManagers";
    public static final String ELEMENT_MANAGER = "manager";
    public static final String ELEMENT_ENGINE = "engine";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    public static final String PREF_REG_ELEMENTS = "kiml.reg.elements";
    public static final String PREF_OBLIQUE_ROUTE = "kiml.oblique.route";
    private final List<Pair<Integer, IDiagramLayoutManager<?>>> managers = new LinkedList();
    private final List<Pair<Integer, IGraphLayoutEngine>> layoutEngines = new LinkedList<Pair<Integer, IGraphLayoutEngine>>();
    private final Set<String> registeredElements = new HashSet<String>();

    public static EclipseLayoutInfoService getInstance() {
        return (EclipseLayoutInfoService)LayoutInfoService.getInstance();
    }

    private EclipseLayoutInfoService() {
    }

    public static synchronized void create() {
        EclipseLayoutInfoService instance = new EclipseLayoutInfoService();
        instance.loadLayoutInfoExtensions();
        instance.loadLayoutManagerExtensions();
        instance.loadPreferences();
    }

    protected void reportError(String extensionPoint, IConfigurationElement element, String attribute, Throwable exception) {
        String message = element != null && attribute != null ? "Extension point " + extensionPoint + ": Invalid entry in attribute '" + attribute + "' of element " + element.getName() + ", contributed by " + element.getContributor().getName() : "Extension point " + extensionPoint + ": An error occured while loading extensions.";
        Status status = new Status(2, "de.cau.cs.kieler.kiml.ui", 0, message, exception);
        StatusManager.getManager().handle((IStatus)status);
    }

    protected void reportError(CoreException exception) {
        StatusManager.getManager().handle(exception, "de.cau.cs.kieler.kiml.ui");
    }

    public IDiagramLayoutManager<?> getManager(IWorkbenchPart workbenchPart, Object diagramPart) {
        for (Pair<Integer, IDiagramLayoutManager<?>> entry : this.managers) {
            IDiagramLayoutManager manager = (IDiagramLayoutManager)entry.getSecond();
            if (!(workbenchPart == null ? manager.supports(diagramPart) : manager.supports(workbenchPart) && (diagramPart == null || manager.supports(diagramPart)))) continue;
            return manager;
        }
        return null;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IDiagramLayoutManager manager = null;
        for (Pair<Integer, IDiagramLayoutManager<?>> entry : this.managers) {
            if (!((IDiagramLayoutManager)entry.getSecond()).supports(adaptableObject)) continue;
            manager = (IDiagramLayoutManager)entry.getSecond();
            break;
        }
        if (manager != null) {
            if (adapterType == null) {
                return manager.getAdapter(adaptableObject, manager.getAdapterList()[0]);
            }
            return manager.getAdapter(adaptableObject, adapterType);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        ArrayList<Class> resultList = new ArrayList<Class>();
        for (Pair<Integer, IDiagramLayoutManager<?>> entry : this.managers) {
            IDiagramLayoutManager manager = (IDiagramLayoutManager)entry.getSecond();
            Class[] classArray = manager.getAdapterList();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class adapterType = classArray[n2];
                resultList.add(adapterType);
                ++n2;
            }
        }
        return resultList.toArray(new Class[resultList.size()]);
    }

    public IGraphLayoutEngine getLayoutEngine() {
        for (Pair<Integer, IGraphLayoutEngine> entry : this.layoutEngines) {
            IGraphLayoutEngine engine = (IGraphLayoutEngine)entry.getSecond();
            if (!engine.isActive()) continue;
            return engine;
        }
        return null;
    }

    public static String getPreferenceName(String id1, String id2) {
        return String.valueOf(id1) + "-" + id2;
    }

    public void storeOption(String diagramType, LayoutOptionData<?> optionData, String valueString) {
        Object value = optionData.parseValue(valueString);
        if (value != null) {
            this.addOptionValue(diagramType, optionData.getId(), value);
            IPreferenceStore preferenceStore = KimlUiPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue(EclipseLayoutInfoService.getPreferenceName(diagramType, optionData.getId()), valueString);
        }
    }

    public void storeOption(Object diagramPart, LayoutOptionData<?> optionData, String valueString, boolean storeDomainModel) {
        Object value = optionData.parseValue(valueString);
        if (value != null) {
            String clazzName;
            if (storeDomainModel) {
                EObject model = (EObject)this.getAdapter(diagramPart, EObject.class);
                clazzName = model == null ? null : model.eClass().getInstanceTypeName();
            } else {
                Object relevantPart = this.getAdapter(diagramPart, null);
                String string = clazzName = relevantPart == null ? null : relevantPart.getClass().getName();
            }
            if (clazzName != null) {
                this.addOptionValue(clazzName, optionData.getId(), value);
                this.registeredElements.add(clazzName);
                IPreferenceStore preferenceStore = KimlUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue(EclipseLayoutInfoService.getPreferenceName(clazzName, optionData.getId()), valueString);
            }
        }
    }

    private void loadLayoutManagerExtensions() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_LAYOUT_MANAGERS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    IGraphLayoutEngine engine;
                    String prioEntry;
                    int priority;
                    if (ELEMENT_MANAGER.equals(element.getName())) {
                        IDiagramLayoutManager manager = (IDiagramLayoutManager)element.createExecutableExtension("class");
                        if (manager == null) break block10;
                        priority = 0;
                        prioEntry = element.getAttribute(ATTRIBUTE_PRIORITY);
                        if (prioEntry != null) {
                            try {
                                priority = Integer.parseInt(prioEntry);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        EclipseLayoutInfoService.insertSorted(manager, priority, this.managers);
                        break block10;
                    }
                    if (!ELEMENT_ENGINE.equals(element.getName()) || (engine = (IGraphLayoutEngine)element.createExecutableExtension("class")) == null) break block10;
                    priority = 0;
                    prioEntry = element.getAttribute(ATTRIBUTE_PRIORITY);
                    if (prioEntry != null) {
                        try {
                            priority = Integer.parseInt(prioEntry);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    EclipseLayoutInfoService.insertSorted(engine, priority, this.layoutEngines);
                }
                catch (CoreException exception) {
                    StatusManager.getManager().handle(exception, "de.cau.cs.kieler.kiml.ui");
                }
            }
            ++n2;
        }
    }

    private static <T> void insertSorted(T object, int priority, List<Pair<Integer, T>> list) {
        ListIterator<Pair<Integer, T>> iter = list.listIterator();
        while (iter.hasNext()) {
            Pair<Integer, T> next = iter.next();
            if ((Integer)next.getFirst() > priority) continue;
            iter.previous();
            break;
        }
        iter.add(new Pair((Object)priority, object));
    }

    private void loadPreferences() {
        IPreferenceStore preferenceStore = KimlUiPlugin.getDefault().getPreferenceStore();
        LayoutDataService layoutDataService = LayoutDataService.getInstance();
        List diagramTypes = this.getDiagramTypes();
        Collection layoutOptionData = layoutDataService.getOptionData();
        for (Pair diagramType : diagramTypes) {
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = EclipseLayoutInfoService.getPreferenceName((String)diagramType.getFirst(), data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                this.addOptionValue((String)diagramType.getFirst(), data.getId(), value);
            }
        }
        StringTokenizer editPartsTokenizer = new StringTokenizer(preferenceStore.getString(PREF_REG_ELEMENTS), ";");
        while (editPartsTokenizer.hasMoreTokens()) {
            this.registeredElements.add(editPartsTokenizer.nextToken());
        }
        for (String elementName : this.registeredElements) {
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = EclipseLayoutInfoService.getPreferenceName(elementName, data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                this.addOptionValue(elementName, data.getId(), value);
            }
        }
    }

    public void storePreferences() {
        IPreferenceStore preferenceStore = KimlUiPlugin.getDefault().getPreferenceStore();
        StringBuilder elementsString = new StringBuilder();
        for (String elementName : this.registeredElements) {
            elementsString.append(String.valueOf(elementName) + ";");
        }
        preferenceStore.setValue(PREF_REG_ELEMENTS, elementsString.toString());
    }

    public Set<String> getRegisteredElements() {
        return this.registeredElements;
    }

    public void fillConfigMenu(IMenuManager menuManager) {
        for (LayoutInfoService.ConfigData data : this.getConfigData()) {
            if (data.getActivationText() == null || data.getActivationText().length() <= 0 || data.getActivationProperty() == null) continue;
            final String text = data.getActivationText();
            final IProperty activation = data.getActivationProperty();
            final Runnable activationAction = data.getActivationAction();
            menuManager.add((IContributionItem)new ContributionItem(){

                public void fill(Menu parent, int index) {
                    final MenuItem menuItem = new MenuItem(parent, 32, index);
                    menuItem.setText(text);
                    menuItem.setSelection(((Boolean)EclipseLayoutInfoService.this.getConfigProperties().getProperty(activation)).booleanValue());
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            EclipseLayoutInfoService.this.getConfigProperties().setProperty(activation, (Object)menuItem.getSelection());
                            if (activationAction != null) {
                                activationAction.run();
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    if (activationAction != null) {
                        activationAction.run();
                    }
                }
            });
        }
    }

    public static /* bridge */ /* synthetic */ LayoutInfoService getInstance() {
        return EclipseLayoutInfoService.getInstance();
    }
}

