/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class VariableServiceGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    private IDataConfiguration configExt;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public void doGenerate(Root root, SubSystemInstance ssi) {
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        String clsname = this.stdExt.getJavaClassName(nr, ssi);
        String path = this.roomExt.getPath((RoomClass)ssi.getSubSystemClass());
        String file = clsname + "VariableService.java";
        this.fileIO.generateFile("generating VariableService implementation", path + file, this.generate(root, ssi));
    }

    private CharSequence generate(Root root, SubSystemInstance comp) {
        CharSequence charSequence;
        Object object;
        Object object2;
        CharSequence charSequence2;
        Object object3;
        String string;
        Iterator iterator;
        Object ai2;
        Iterator<Object> iterator2;
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this.stdExt.getJavaClassName(nr, comp);
        HashMap aisAttrMap = new HashMap();
        Consumer<ActorInstance> consumer = ai -> {
            boolean bl;
            boolean bl2 = this.configExt.getDynConfigReadAttributes(ai).isEmpty();
            boolean bl3 = bl = !bl2;
            if (bl) {
                aisAttrMap.put(ai, this.configExt.getDynConfigReadAttributes(ai));
            }
        };
        comp.getAllContainedInstances().forEach(consumer);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.newLine();
        stringConcatenation2.append("package ");
        String string2 = this.roomExt.getPackage((RoomClass)comp.getSubSystemClass());
        stringConcatenation2.append(string2);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("import java.util.Arrays;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import java.util.HashMap;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import java.util.Map;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.config.AbstractVariableService;");
        stringConcatenation2.newLine();
        String string3 = this.configExt.getUserCode1(comp);
        stringConcatenation2.append(string3);
        stringConcatenation2.newLineIfNotEmpty();
        Object object4 = this.getRoomModels(aisAttrMap.keySet());
        Object object5 = ((HashSet)object4).iterator();
        while (object5.hasNext()) {
            RoomModel model = object5.next();
            stringConcatenation2.append("import ");
            iterator2 = model.getName();
            stringConcatenation2.append((String)((Object)iterator2));
            stringConcatenation2.append(".*;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public class ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("VariableService extends AbstractVariableService{");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("private ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append(" subSystem;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// Actor instances");
        stringConcatenation2.newLine();
        object4 = aisAttrMap.keySet();
        object5 = object4.iterator();
        while (object5.hasNext()) {
            ai2 = (ActorInstance)object5.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("private ");
            iterator2 = ai2.getActorClass().getName();
            stringConcatenation2.append((String)((Object)iterator2), "\t");
            stringConcatenation2.append(" ");
            iterator = this.getVarName((ActorInstance)ai2);
            stringConcatenation2.append((Object)iterator, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("VariableService(");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append(" subSystem) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super(");
        object4 = this.configExt.getUserCode2(comp);
        stringConcatenation2.append((String)object4, "\t\t");
        stringConcatenation2.append(");");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("this.subSystem = subSystem;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected void initInstances(){");
        stringConcatenation2.newLine();
        ai2 = aisAttrMap.keySet();
        iterator2 = ai2.iterator();
        while (iterator2.hasNext()) {
            ActorInstance ai_1 = (ActorInstance)iterator2.next();
            stringConcatenation2.append("\t\t");
            iterator = this.getVarName(ai_1);
            stringConcatenation2.append((Object)iterator, "\t\t");
            stringConcatenation2.append(" = (");
            string = ai_1.getActorClass().getName();
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append(")subSystem.getInstance(\"");
            object3 = ai_1.getPath();
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected void setAttributeValues(Map<String, Object> values) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("Object object;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("String id = null;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        ai2 = aisAttrMap.keySet();
        iterator2 = ai2.iterator();
        while (iterator2.hasNext()) {
            ActorInstance ai_2 = (ActorInstance)iterator2.next();
            iterator = (List)aisAttrMap.get(ai_2);
            object3 = iterator.iterator();
            while (object3.hasNext()) {
                Attribute a = (Attribute)object3.next();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("try{");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("boolean changed = false;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                charSequence2 = this.genSetAttributeValues1(this.roomExt.union(new ArrayList(), (Object)a), ai_2);
                stringConcatenation2.append((Object)charSequence2, "\t\t\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("if(changed)");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("synchronized(");
                object2 = this.getVarName(ai_2);
                stringConcatenation2.append(object2, "\t\t\t\t");
                stringConcatenation2.append(".");
                String string4 = a.getName();
                object = string4 + "Lock";
                charSequence = this.helpers.invokeGetter((String)object, null);
                stringConcatenation2.append((Object)charSequence, "\t\t\t\t");
                stringConcatenation2.append("){");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("if(");
                CharSequence charSequence3 = this.getVarName(ai_2);
                stringConcatenation2.append((Object)charSequence3, "\t\t\t\t\t");
                stringConcatenation2.append(".");
                String string5 = a.getName();
                String string6 = string5 + "Lock";
                CharSequence charSequence4 = this.helpers.invokeGetter(string6, null);
                stringConcatenation2.append((Object)charSequence4, "\t\t\t\t\t");
                stringConcatenation2.append(".isUpdate()){");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t\t\t");
                CharSequence charSequence5 = this.genSetAttributeValues2(this.roomExt.union(new ArrayList(), (Object)a), ai_2);
                stringConcatenation2.append((Object)charSequence5, "\t\t\t\t\t\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}catch(IllegalArgumentException e){");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("error(id, e);");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected Map<String, Object> getAttributeValues(){");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("Map<String, Object> values = new HashMap<String, Object>();");
        stringConcatenation2.newLine();
        ai2 = aisAttrMap.keySet();
        iterator2 = ai2.iterator();
        while (iterator2.hasNext()) {
            ActorInstance ai_3 = (ActorInstance)iterator2.next();
            iterator = (List)aisAttrMap.get(ai_3);
            object3 = iterator.iterator();
            while (object3.hasNext()) {
                Attribute a_1 = (Attribute)object3.next();
                stringConcatenation2.append("\t\t");
                charSequence2 = this.genGetAttributeValues(this.roomExt.union(new ArrayList(), (Object)a_1), ai_3);
                stringConcatenation2.append((Object)charSequence2, "\t\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return values;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void writeDataClass(String id, Object dcObject, Map<String, Object> writeMap) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        HashSet<DataClass> dataClasses = this.getDynConfigDataClasses(aisAttrMap.keySet());
        stringConcatenation2.newLineIfNotEmpty();
        for (DataClass dc : dataClasses) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("if(dcObject.getClass().equals(");
            iterator = this._typeHelpers.typeName((DataType)dc);
            stringConcatenation2.append((String)((Object)iterator), "\t\t");
            stringConcatenation2.append(".class))");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("writeDataClass(id, (");
            string = this._typeHelpers.typeName((DataType)dc);
            stringConcatenation2.append(string, "\t\t\t");
            stringConcatenation2.append(") dcObject, writeTasks);");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// DataClasses write operations");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        object5 = this.getAllDataClasses(dataClasses);
        iterator = ((HashSet)object5).iterator();
        while (iterator.hasNext()) {
            DataClass dc_1 = (DataClass)iterator.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("private void writeDataClass(String id, ");
            string = this._typeHelpers.typeName((DataType)dc_1);
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.append(" object, Map<String, Object> map){");
            stringConcatenation2.newLineIfNotEmpty();
            object3 = this._roomHelpers.getAllAttributes(dc_1);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                Attribute a_2 = (Attribute)object2.next();
                boolean bl = this._typeHelpers.isEnumerationOrPrimitive(a_2.getType().getType());
                if (bl) {
                    boolean bl2;
                    int n;
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("map.put(id+\"/");
                    object = a_2.getName();
                    stringConcatenation2.append((String)object, "\t\t");
                    stringConcatenation2.append("\", ");
                    int n2 = a_2.getSize();
                    int n3 = n = n2 > 0 ? 1 : 0;
                    if (n != 0) {
                        stringConcatenation2.append("toObjectArray(");
                    }
                    stringConcatenation2.append("object.");
                    charSequence = this.helpers.invokeGetter(a_2.getName(), null);
                    stringConcatenation2.append((Object)charSequence, "\t\t");
                    n = a_2.getSize();
                    boolean bl3 = bl2 = n > 0;
                    if (bl2) {
                        stringConcatenation2.append(")");
                    }
                    stringConcatenation2.append(");");
                    stringConcatenation2.newLineIfNotEmpty();
                    continue;
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("writeDataClass(id+\"/");
                object = a_2.getName();
                stringConcatenation2.append((String)object, "\t\t");
                stringConcatenation2.append("\", object.");
                charSequence = this.helpers.invokeGetter(a_2.getName(), null);
                stringConcatenation2.append((Object)charSequence, "\t\t");
                stringConcatenation2.append(", map);");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected int getPollingTimerUser(){");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return ");
        long l = TimeConverter.split((long)this.configExt.getPollingTimerUser(comp), (String)"ms", (boolean)true);
        stringConcatenation2.append((Object)l, "\t\t");
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genMinMaxCheck(List<Attribute> path, ActorClass ac) {
        StringConcatenation stringConcatenation = null;
        Attribute a = (Attribute)IterableExtensions.last(path);
        String aVarName = this.toAbsolutePath(path, "_");
        String string = this.configExt.getAttrClassConfigMinValue(ac, path);
        boolean min = string != null;
        String string2 = this.configExt.getAttrClassConfigMaxValue(ac, path);
        boolean max = string2 != null;
        StringConcatenation stringConcatenation2 = null;
        if (min || max) {
            boolean bl;
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            int n = a.getSize();
            boolean bl2 = bl = n > 0;
            if (bl) {
                stringConcatenation3.append("for(");
                String string3 = this._typeHelpers.typeName(a.getType().getType());
                stringConcatenation3.append(string3);
                stringConcatenation3.append(" e : ");
                stringConcatenation3.append(aVarName);
                stringConcatenation3.append(")");
                stringConcatenation3.newLineIfNotEmpty();
                stringConcatenation3.append("\t");
            }
            stringConcatenation3.append("checkMinMax(");
            n = a.getSize();
            boolean bl3 = bl = n > 0;
            if (bl) {
                stringConcatenation3.append("e");
            } else {
                stringConcatenation3.append(aVarName);
            }
            stringConcatenation3.append(", ");
            if (min) {
                String string4 = ac.getName();
                stringConcatenation3.append(string4);
                stringConcatenation3.append(".MIN");
                stringConcatenation3.append(aVarName);
            } else {
                stringConcatenation3.append("null");
            }
            stringConcatenation3.append(", ");
            if (max) {
                String string5 = ac.getName();
                stringConcatenation3.append(string5);
                stringConcatenation3.append(".MAX");
                stringConcatenation3.append(aVarName);
            } else {
                stringConcatenation3.append("null");
            }
            stringConcatenation3.append(");");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation2 = stringConcatenation3;
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private HashSet<DataClass> getDynConfigDataClasses(Iterable<ActorInstance> ais) {
        HashSet<DataClass> result = new HashSet<DataClass>();
        Consumer<ActorInstance> consumer = ai -> {
            Consumer<Attribute> consumer = a -> {
                boolean bl = this._typeHelpers.isDataClass(a.getType().getType());
                if (bl) {
                    DataType dataType = a.getType().getType();
                    result.add((DataClass)dataType);
                }
            };
            this.configExt.getDynConfigReadAttributes(ai).forEach(consumer);
        };
        ais.forEach(consumer);
        return result;
    }

    private HashSet<DataClass> getAllDataClasses(Iterable<DataClass> dcs) {
        HashSet<DataClass> result = new HashSet<DataClass>();
        Iterables.addAll(result, dcs);
        LinkedList visit = new LinkedList();
        Iterables.addAll(visit, dcs);
        while (!visit.isEmpty()) {
            DataClass dc = (DataClass)visit.pop();
            Consumer<Attribute> consumer = a -> {
                boolean bl = this._typeHelpers.isDataClass(a.getType().getType());
                if (bl) {
                    DataType dataType = a.getType().getType();
                    visit.add((DataClass)dataType);
                }
            };
            this._roomHelpers.getAllAttributes(dc).forEach(consumer);
        }
        return result;
    }

    private HashSet<RoomModel> getRoomModels(Collection<ActorInstance> ais) {
        HashSet<RoomModel> models = new HashSet<RoomModel>();
        Consumer<ActorInstance> consumer = ai -> {
            EObject eObject = ai.getActorClass().eContainer();
            models.add((RoomModel)eObject);
        };
        ais.forEach(consumer);
        return models;
    }

    private String toAbsolutePath(List<Attribute> path, String pathDelim) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Attribute p : path) {
            stringConcatenation.append(pathDelim);
            String string = p.getName();
            stringConcatenation.append(string);
        }
        return stringConcatenation.toString();
    }

    private CharSequence getVarName(ActorInstance ai) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        Iterable iterable = IterableExtensions.drop((Iterable)((Iterable)Conversions.doWrapArray((Object)ai.getPath().split("/"))), (int)2);
        boolean bl = false;
        for (String p : iterable) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation.appendImmediate((Object)"_", "");
            }
            stringConcatenation.append(p);
        }
        return stringConcatenation;
    }

    private CharSequence genGetAttributeValues(List<Attribute> path, ActorInstance ai) {
        StringConcatenation stringConcatenation = null;
        Attribute a = (Attribute)IterableExtensions.last(path);
        StringConcatenation stringConcatenation2 = null;
        boolean bl = this._typeHelpers.isEnumerationOrPrimitive(a.getType().getType());
        if (bl) {
            boolean bl2;
            boolean bl3;
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            stringConcatenation3.append("values.put(\"");
            String string = ai.getPath();
            stringConcatenation3.append(string);
            String string2 = this.toAbsolutePath(path, "/");
            stringConcatenation3.append(string2);
            stringConcatenation3.append("\", ");
            int n = a.getSize();
            boolean bl4 = bl3 = n > 0;
            if (bl3) {
                stringConcatenation3.append("toObjectArray(");
            }
            CharSequence charSequence = this.getVarName(ai);
            stringConcatenation3.append((Object)charSequence);
            stringConcatenation3.append(".");
            CharSequence charSequence2 = this.helpers.invokeGetters(path, null);
            stringConcatenation3.append((Object)charSequence2);
            int n2 = a.getSize();
            boolean bl5 = bl2 = n2 > 0;
            if (bl2) {
                stringConcatenation3.append(")");
            }
            stringConcatenation3.append(");");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation2 = stringConcatenation3;
        } else {
            StringConcatenation stringConcatenation4 = null;
            boolean bl6 = this._typeHelpers.isDataClass(a.getType().getType());
            if (bl6) {
                StringConcatenation stringConcatenation5 = null;
                DataType dataType = a.getType().getType();
                DataClass dataClass = (DataClass)dataType;
                StringConcatenation stringConcatenation6 = new StringConcatenation();
                List list = this._roomHelpers.getAllAttributes(dataClass);
                for (Attribute at : list) {
                    CharSequence charSequence = this.genGetAttributeValues(this.roomExt.union(path, (Object)at), ai);
                    stringConcatenation6.append((Object)charSequence);
                    stringConcatenation6.newLineIfNotEmpty();
                }
                stringConcatenation4 = stringConcatenation5 = stringConcatenation6;
            }
            stringConcatenation2 = stringConcatenation4;
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genSetAttributeValues1(List<Attribute> path, ActorInstance ai) {
        StringConcatenation stringConcatenation = null;
        Attribute a = (Attribute)IterableExtensions.last(path);
        String aVarName = this.toAbsolutePath(path, "_");
        StringConcatenation stringConcatenation2 = null;
        boolean bl = this._typeHelpers.isEnumerationOrPrimitive(a.getType().getType());
        if (bl) {
            int n;
            int n2;
            int n3;
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            stringConcatenation3.append("id = \"");
            String string = ai.getPath();
            stringConcatenation3.append(string);
            String string2 = this.toAbsolutePath(path, "/");
            stringConcatenation3.append(string2);
            stringConcatenation3.append("\";");
            stringConcatenation3.newLineIfNotEmpty();
            int n4 = a.getSize();
            int n5 = n3 = n4 == 0 ? 1 : 0;
            if (n3 != 0) {
                var13_20 = this.stdExt.toWrapper(this._typeHelpers.typeName(a.getType().getType()));
                stringConcatenation3.append(var13_20);
            } else {
                var13_20 = this._typeHelpers.typeName(a.getType().getType());
                stringConcatenation3.append(var13_20);
                stringConcatenation3.append("[]");
            }
            stringConcatenation3.append(" ");
            stringConcatenation3.append(aVarName);
            stringConcatenation3.append(" = null;");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation3.append("object = values.get(id);");
            stringConcatenation3.newLine();
            stringConcatenation3.append("if(object != null){");
            stringConcatenation3.newLine();
            stringConcatenation3.append("\t");
            stringConcatenation3.append(aVarName, "\t");
            stringConcatenation3.append(" = ensure");
            String string3 = StringExtensions.toFirstUpper((String)this._typeHelpers.typeName(a.getType().getType()));
            stringConcatenation3.append(string3, "\t");
            n3 = a.getSize();
            int n6 = n2 = n3 > 0 ? 1 : 0;
            if (n2 != 0) {
                stringConcatenation3.append("Array");
            }
            stringConcatenation3.append("(object");
            n3 = a.getSize();
            int n7 = n2 = n3 > 0 ? 1 : 0;
            if (n2 != 0) {
                stringConcatenation3.append(", ");
                n = a.getSize();
                stringConcatenation3.append((Object)n, "\t");
            }
            stringConcatenation3.append(");");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation3.append("\t");
            CharSequence charSequence = this.genMinMaxCheck(path, ai.getActorClass());
            stringConcatenation3.append((Object)charSequence, "\t");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation3.append("\t");
            stringConcatenation3.append("if(!");
            n2 = a.getSize();
            int n8 = n = n2 == 0 ? 1 : 0;
            if (n != 0) {
                stringConcatenation3.append(aVarName, "\t");
                stringConcatenation3.append(".equals(");
            } else {
                stringConcatenation3.append("Arrays.equals(");
                stringConcatenation3.append(aVarName, "\t");
                stringConcatenation3.append(", ");
            }
            stringConcatenation3.append("(");
            n2 = a.getSize();
            int n9 = n = n2 == 0 ? 1 : 0;
            if (n != 0) {
                String string4 = this.stdExt.toWrapper(this._typeHelpers.typeName(a.getType().getType()));
                stringConcatenation3.append(string4, "\t");
            } else {
                String string5 = this._typeHelpers.typeName(a.getType().getType());
                stringConcatenation3.append(string5, "\t");
                stringConcatenation3.append("[]");
            }
            stringConcatenation3.append(")getDiffMap().get(id)))");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation3.append("\t\t");
            stringConcatenation3.append("changed = true;");
            stringConcatenation3.newLine();
            stringConcatenation3.append("} else");
            stringConcatenation3.newLine();
            stringConcatenation3.append("\t");
            stringConcatenation3.append("warning(id, \"is missing\");");
            stringConcatenation3.newLine();
            stringConcatenation2 = stringConcatenation3;
        } else {
            StringConcatenation stringConcatenation4 = null;
            boolean bl2 = this._typeHelpers.isDataClass(a.getType().getType());
            if (bl2) {
                StringConcatenation stringConcatenation5 = null;
                DataType dataType = a.getType().getType();
                DataClass dataClass = (DataClass)dataType;
                StringConcatenation stringConcatenation6 = new StringConcatenation();
                List list = this._roomHelpers.getAllAttributes(dataClass);
                for (Attribute at : list) {
                    CharSequence charSequence = this.genSetAttributeValues1(this.roomExt.union(path, (Object)at), ai);
                    stringConcatenation6.append((Object)charSequence);
                    stringConcatenation6.newLineIfNotEmpty();
                }
                stringConcatenation4 = stringConcatenation5 = stringConcatenation6;
            }
            stringConcatenation2 = stringConcatenation4;
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genSetAttributeValues2(List<Attribute> path, ActorInstance ai) {
        StringConcatenation stringConcatenation = null;
        Attribute a = (Attribute)IterableExtensions.last(path);
        String aVarName = this.toAbsolutePath(path, "_");
        StringConcatenation stringConcatenation2 = null;
        boolean bl = this._typeHelpers.isEnumerationOrPrimitive(a.getType().getType());
        if (bl) {
            CharSequence charSequence;
            boolean bl2;
            StringConcatenation stringConcatenation3 = null;
            Object object = null;
            int n = path.size();
            boolean bl3 = bl2 = n > 1;
            if (bl2) {
                int n2 = path.size();
                int n3 = n2 - 1;
                charSequence = this.helpers.invokeGetters(IterableExtensions.take(path, (int)n3), null);
                object = String.valueOf(charSequence) + ".";
            } else {
                object = "";
            }
            String getters = object;
            StringConcatenation stringConcatenation4 = new StringConcatenation();
            stringConcatenation4.append("if(");
            stringConcatenation4.append(aVarName);
            stringConcatenation4.append(" != null){");
            stringConcatenation4.newLineIfNotEmpty();
            stringConcatenation4.append("\t");
            charSequence = this.getVarName(ai);
            stringConcatenation4.append((Object)charSequence, "\t");
            stringConcatenation4.append(".");
            stringConcatenation4.append(getters, "\t");
            CharSequence charSequence2 = this.helpers.invokeSetter(a.getName(), null, aVarName);
            stringConcatenation4.append((Object)charSequence2, "\t");
            stringConcatenation4.append(";");
            stringConcatenation4.newLineIfNotEmpty();
            stringConcatenation4.append("\t");
            stringConcatenation4.append("getDiffMap().put(\"");
            String string = ai.getPath();
            stringConcatenation4.append(string, "\t");
            String string2 = this.toAbsolutePath(path, "/");
            stringConcatenation4.append(string2, "\t");
            stringConcatenation4.append("\", ");
            stringConcatenation4.append(aVarName, "\t");
            stringConcatenation4.append(");");
            stringConcatenation4.newLineIfNotEmpty();
            stringConcatenation4.append("}");
            stringConcatenation4.newLine();
            stringConcatenation2 = stringConcatenation3 = stringConcatenation4;
        } else {
            StringConcatenation stringConcatenation5 = null;
            boolean bl4 = this._typeHelpers.isDataClass(a.getType().getType());
            if (bl4) {
                StringConcatenation stringConcatenation6 = null;
                DataType dataType = a.getType().getType();
                DataClass dataClass = (DataClass)dataType;
                StringConcatenation stringConcatenation7 = new StringConcatenation();
                List list = this._roomHelpers.getAllAttributes(dataClass);
                for (Attribute at : list) {
                    CharSequence charSequence = this.genSetAttributeValues2(this.roomExt.union(path, (Object)at), ai);
                    stringConcatenation7.append((Object)charSequence);
                    stringConcatenation7.newLineIfNotEmpty();
                }
                stringConcatenation5 = stringConcatenation6 = stringConcatenation7;
            }
            stringConcatenation2 = stringConcatenation5;
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

