/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.OpenBinding;
import org.eclipse.etrice.core.genmodel.etricegen.OpenServiceConnection;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class OptionalActorFactoryGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public void doGenerate(Root root) {
        HashMap ac2wired = new HashMap();
        Functions.Function1 function1 = w -> w instanceof WiredActorClass;
        Consumer<WiredStructureClass> consumer = w -> ac2wired.put(((WiredActorClass)w).getActorClass(), (WiredActorClass)w);
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)function1).forEach(consumer);
        EList eList = root.getOptionalInstances();
        for (OptionalActorInstance oi : eList) {
            ActorClass ac = oi.getActorClass();
            WiredActorClass wired = (WiredActorClass)ac2wired.get(ac);
            String path = this._roomExtensions.getPath((RoomClass)ac);
            String file = this._javaExtensions.getJavaFactoryFileName(ac);
            this.fileIO.generateFile("generating ActorClass Interface implementation", path + file, this.generate(root, oi, wired));
        }
    }

    public CharSequence generate(Root root, OptionalActorInstance oi, WiredActorClass wired) {
        Object object;
        String string;
        String string2;
        boolean bl;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = oi.getActorClass();
        String clsname = this._javaExtensions.getJavaFactoryName(ac);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string3 = this._roomExtensions.getPackage((RoomClass)ac);
        stringConcatenation2.append(string3);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("import ");
        String string4 = this._roomExtensions.getPackage((RoomClass)ac);
        stringConcatenation2.append(string4);
        stringConcatenation2.append(".");
        String string5 = ac.getName();
        stringConcatenation2.append(string5);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.OptionalActorInterfaceBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.IOptionalActorFactory;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public class ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" implements IOptionalActorFactory {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        String string6 = ac.getName();
        stringConcatenation2.append(string6, "\t");
        stringConcatenation2.append(" create(OptionalActorInterfaceBase ai, String name) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// instantiate sub tree");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        String string7 = ac.getName();
        stringConcatenation2.append(string7, "\t\t");
        stringConcatenation2.append(" actor = new ");
        String string8 = ac.getName();
        stringConcatenation2.append(string8, "\t\t");
        stringConcatenation2.append("(ai, name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// wiring");
        stringConcatenation2.newLine();
        Functions.Function1 function1 = p -> this._roomHelpers.isExternal(p);
        Iterable iterable = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function1);
        for (Port port : iterable) {
            stringConcatenation2.append("\t\t");
            String string9 = null;
            bl = this._roomHelpers.isDataDriven((InterfaceItem)port);
            string9 = bl ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append(string9, "\t\t");
            stringConcatenation2.append(".connect(ai, \"");
            string2 = port.getName();
            stringConcatenation2.append(string2, "\t\t");
            stringConcatenation2.append("\", name+\"/");
            string = port.getName();
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        function1 = wired.getOpenBindings();
        for (OpenBinding open : function1) {
            stringConcatenation2.append("\t\t");
            object = null;
            boolean bl2 = this._roomHelpers.isDataDriven((InterfaceItem)open.getPort());
            object = bl2 ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append(".connect(ai, \"");
            String string10 = open.getPort().getName();
            stringConcatenation2.append(string10, "\t\t");
            stringConcatenation2.append("\", name+\"/");
            string2 = IterableExtensions.join((Iterable)open.getPath(), (CharSequence)"/");
            stringConcatenation2.append(string2, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        function1 = wired.getRequiredServices();
        for (OpenServiceConnection req : function1) {
            stringConcatenation2.append("\t\t");
            object = null;
            CommunicationType communicationType = req.getProtocol().getCommType();
            bl = Objects.equal((Object)communicationType, (Object)CommunicationType.DATA_DRIVEN);
            object = bl ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append(".connect(ai, \"");
            string2 = this._roomExtensions.getFullyQualifiedName((RoomClass)req.getProtocol());
            stringConcatenation2.append(string2, "\t\t");
            stringConcatenation2.append("\", name+\"/");
            string = IterableExtensions.join((Iterable)req.getPath(), (CharSequence)"/");
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return actor;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

