/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.cli;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.args.BooleanOption;
import org.eclipse.etrice.generator.base.args.EnumOption;
import org.eclipse.etrice.generator.base.args.Option;
import org.eclipse.etrice.generator.base.args.Options;
import org.eclipse.etrice.generator.base.args.PathOption;
import org.eclipse.etrice.generator.base.args.StringOption;
import org.eclipse.etrice.generator.base.cli.CommandLineParseException;
import org.eclipse.etrice.generator.base.cli.ICommandLineParser;

public class CommandLineParser
implements ICommandLineParser {
    @Override
    public Arguments parseArgs(Options options, Option<String[]> defaultOption, List<String> args) throws CommandLineParseException {
        Arguments parsedArgs = new Arguments(options);
        List<String> nArgs = this.normalize(args);
        ListIterator<String> iterator = nArgs.listIterator();
        LinkedList<String> defaultArgs = new LinkedList<String>();
        while (iterator.hasNext()) {
            String str = iterator.next().trim();
            if (str.startsWith("-")) {
                Option<?> opt = this.parseOption(options, str);
                Object value = this.parseValue(opt, iterator);
                parsedArgs.set(opt.getName(), value);
                continue;
            }
            defaultArgs.add(str);
        }
        if (!defaultArgs.isEmpty()) {
            parsedArgs.set(defaultOption, defaultArgs.toArray(new String[0]));
        }
        return parsedArgs;
    }

    private List<String> normalize(List<String> args) throws CommandLineParseException {
        LinkedList<String> nArgs = new LinkedList<String>(args);
        return nArgs;
    }

    private Option<?> parseOption(Options options, String str) throws CommandLineParseException {
        try {
            String optionName = str.substring(1);
            Option<?> opt = options.get(optionName);
            return opt;
        }
        catch (IllegalArgumentException e) {
            throw new CommandLineParseException("Option " + str + " not recognized");
        }
    }

    private Object parseValue(Option<?> opt, ListIterator<String> iterator) throws CommandLineParseException {
        if (opt instanceof BooleanOption) {
            return true;
        }
        if (iterator.hasNext()) {
            String str = iterator.next();
            if (opt instanceof StringOption) {
                return str;
            }
            if (opt instanceof PathOption) {
                return str.split(File.pathSeparator);
            }
            if (opt instanceof EnumOption) {
                return this.parseEnum(opt, str);
            }
            throw new CommandLineParseException("Option " + opt.getName() + " is not supported on the command line");
        }
        throw new CommandLineParseException("Expected one argument for option " + opt.getName());
    }

    private Object parseEnum(Option<?> opt, String str) {
        ?[] constants;
        ?[] objArray = constants = opt.getType().getEnumConstants();
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = objArray[n2];
            if (c.toString().equalsIgnoreCase(str)) {
                return c;
            }
            ++n2;
        }
        throw new CommandLineParseException("Argument " + str + " not allowed for option " + opt.getName());
    }
}

