/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.handlers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MigrateTransitionData
extends AbstractHandler {
    public static final String genericDataName = "transitionData";
    @Inject
    private IWhitespaceInformationProvider whitespaceProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor editor;
        boolean proceed = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Migrate to new style of transition data", (String)"This migration will replace textual occurrences of old data names with the generic name 'transitionData'\n\nProceed?");
        if (proceed && (editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event)) != null) {
            IXtextDocument iXtextDocument = editor.getDocument();
            MigrateContext ctx = (MigrateContext)iXtextDocument.modify((IUnitOfWork)new IUnitOfWork<MigrateContext, XtextResource>(){

                public MigrateContext exec(final XtextResource state) throws Exception {
                    MigrateContext migrateContext = new MigrateContext();
                    Procedures.Procedure1<MigrateContext> procedure1 = new Procedures.Procedure1<MigrateContext>(){

                        public void apply(MigrateContext it) {
                            it.lineSep = (this).MigrateTransitionData.this.whitespaceProvider.getLineSeparatorInformation(state.getURI()).getLineSeparator();
                        }
                    };
                    MigrateContext ctx = (MigrateContext)ObjectExtensions.operator_doubleArrow((Object)migrateContext, (Procedures.Procedure1)procedure1);
                    EList eList = state.getContents();
                    for (EObject model : eList) {
                        if (!(model instanceof RoomModel)) continue;
                        MigrateTransitionData.this.migrateModel((RoomModel)model, ctx);
                    }
                    return ctx;
                }
            });
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Migrate to new style of transition data", (String)("Did replacements in " + Integer.valueOf(ctx.actionCodeReplacements) + " action codes."));
        }
        return null;
    }

    private void migrateModel(RoomModel model, final MigrateContext ctx) {
        Consumer<TriggeredTransition> consumer = new Consumer<TriggeredTransition>(){

            @Override
            public void accept(TriggeredTransition it) {
                boolean bl;
                Trigger trigger = (Trigger)IterableExtensions.head((Iterable)it.getTriggers());
                EList eList = null;
                if (trigger != null) {
                    eList = trigger.getMsgFromIfPairs();
                }
                MessageFromIf messageFromIf = null;
                if (eList != null) {
                    messageFromIf = (MessageFromIf)IterableExtensions.head((Iterable)eList);
                }
                EObject eObject = null;
                if (messageFromIf != null) {
                    eObject = messageFromIf.getMessage();
                }
                EObject msg = eObject;
                Trigger trigger2 = (Trigger)IterableExtensions.head((Iterable)it.getTriggers());
                Guard guard = null;
                if (trigger2 != null) {
                    guard = trigger2.getGuard();
                }
                boolean bl2 = bl = guard != null;
                if (bl) {
                    Guard guard2 = ((Trigger)IterableExtensions.head((Iterable)it.getTriggers())).getGuard();
                    guard2.setGuard(MigrateTransitionData.this.makeActionCodeReplacements(msg, ((Trigger)IterableExtensions.head((Iterable)it.getTriggers())).getGuard().getGuard(), ctx));
                }
                it.setAction(MigrateTransitionData.this.makeActionCodeReplacements(msg, it.getAction(), ctx));
            }
        };
        Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)model.eAllContents()), TriggeredTransition.class).forEach(consumer);
        Consumer<MessageHandler> consumer2 = new Consumer<MessageHandler>(){

            @Override
            public void accept(MessageHandler it) {
                it.setDetailCode(MigrateTransitionData.this.makeActionCodeReplacements((EObject)it.getMsg(), it.getDetailCode(), ctx));
            }
        };
        Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)model.eAllContents()), MessageHandler.class).forEach(consumer2);
    }

    private DetailCode makeActionCodeReplacements(EObject msg, DetailCode action, MigrateContext ctx) {
        if (msg instanceof Message && ((Message)msg).getData() != null && ((Message)msg).getData().getDeprecatedName() != null && action != null && !action.getLines().isEmpty()) {
            String detailCode = IterableExtensions.join((Iterable)action.getLines(), (CharSequence)ctx.lineSep);
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("(?<![\\d\\w_])");
            String string = ((Message)msg).getData().getDeprecatedName();
            stringConcatenation.append(string);
            stringConcatenation.append("(?![\\d\\w_])");
            final Matcher matcher = Pattern.compile(stringConcatenation.toString()).matcher(detailCode);
            boolean bl = matcher.find();
            if (bl) {
                int n = ctx.actionCodeReplacements;
                ctx.actionCodeReplacements = n + 1;
                DetailCode detailCode2 = FSMFactory.eINSTANCE.createDetailCode();
                Procedures.Procedure1<DetailCode> procedure1 = new Procedures.Procedure1<DetailCode>(){

                    public void apply(DetailCode it) {
                        EList eList = it.getLines();
                        String string = matcher.replaceAll(MigrateTransitionData.genericDataName);
                        eList.add((Object)string);
                        it.setUsed(false);
                    }
                };
                return (DetailCode)ObjectExtensions.operator_doubleArrow((Object)detailCode2, (Procedures.Procedure1)procedure1);
            }
        }
        return action;
    }

    public static class MigrateContext {
        private String lineSep;
        private int actionCodeReplacements = 0;
    }
}

