/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FsmGenExtensions {
    protected static String _getName(Node nd) {
        return nd.getStateGraphNode().getName();
    }

    protected static String _getName(Link l) {
        return l.getTransition().getName();
    }

    public static Iterable<Node> getStateNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof State;
            }
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)function1);
    }

    public static Iterator<Node> getAllNodes(Graph g) {
        return Iterators.filter((Iterator)g.eAllContents(), Node.class);
    }

    public static Iterator<Node> getAllStateNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof State;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)function1);
    }

    public static Iterable<Node> getChoicePointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof ChoicePoint;
            }
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)function1);
    }

    public static Iterator<Node> getAllChoicePointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof ChoicePoint;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)function1);
    }

    public static Iterable<Node> getTrPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof TrPoint;
            }
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)function1);
    }

    public static Iterator<Node> getAllTrPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof TrPoint;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)function1);
    }

    public static Iterable<Node> getTransitionPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof TransitionPoint;
            }
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)function1);
    }

    public static Iterator<Node> getAllTransitionPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof TransitionPoint;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)function1);
    }

    public static Iterable<Node> getEntryPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof EntryPoint;
            }
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)function1);
    }

    public static Iterator<Node> getAllEntryPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof EntryPoint;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)function1);
    }

    public static Iterable<Node> getExitPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof ExitPoint;
            }
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)function1);
    }

    public static Iterator<Node> getAllExitPointNodes(Graph g) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return stateGraphNode instanceof ExitPoint;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)function1);
    }

    public static Iterable<State> getStates(Graph g) {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getStateNodes(g), (Functions.Function1)function1), State.class);
    }

    public static Iterator<State> getAllStates(Graph g) {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return Iterators.filter((Iterator)IteratorExtensions.map(FsmGenExtensions.getAllStateNodes(g), (Functions.Function1)function1), State.class);
    }

    public static Iterable<ChoicePoint> getChoicePoints(Graph g) {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getChoicePointNodes(g), (Functions.Function1)function1), ChoicePoint.class);
    }

    public static Iterable<TrPoint> getTrPoints(Graph g) {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getTrPointNodes(g), (Functions.Function1)function1), TrPoint.class);
    }

    public static List<DetailCode> getAllActionCodes(Link l) {
        Function<TransitionBase, DetailCode> function = new Function<TransitionBase, DetailCode>(){

            @Override
            public DetailCode apply(TransitionBase it) {
                return it.getAction();
            }
        };
        Predicate<DetailCode> predicate = new Predicate<DetailCode>(){

            @Override
            public boolean test(DetailCode it) {
                return it != null;
            }
        };
        return Stream.concat(Stream.of(l.getTransition()), l.getRefinements().stream()).map(function).filter(predicate).collect(Collectors.toList());
    }

    public static InitialTransition getInitialTransition(Graph g) {
        Functions.Function1<Link, Transition> function1 = new Functions.Function1<Link, Transition>(){

            public Transition apply(Link it) {
                return it.getTransition();
            }
        };
        return (InitialTransition)IterableExtensions.head((Iterable)Iterables.filter((Iterable)ListExtensions.map(g.getLinks(), (Functions.Function1)function1), InitialTransition.class));
    }

    public static Iterator<Link> getAllLinks(Graph g) {
        return Iterators.filter((Iterator)g.eAllContents(), Link.class);
    }

    public static Iterator<Link> getAllInitialTranisitionLinks(Graph g) {
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof InitialTransition;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)function1);
    }

    public static Iterator<Link> getAllTriggeredTranisitionLinks(Graph g) {
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof TriggeredTransition;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)function1);
    }

    public static Iterator<Link> getAllContinuationTranisitionLinks(Graph g) {
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof ContinuationTransition;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)function1);
    }

    public static Iterator<Link> getAllCPBranchTranisitionLinks(Graph g) {
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof CPBranchTransition;
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)function1);
    }

    public static Iterator<Link> getAllChainHeads(Graph g) {
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                return FsmGenExtensions.isChainHead(it);
            }
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)function1);
    }

    public static boolean isChainHead(Link l) {
        return FsmGenExtensions.isChainHead(l.getTransition());
    }

    public static boolean isChainHead(Transition t) {
        return t instanceof InitialTransition || t instanceof GuardedTransition || t instanceof TriggeredTransition;
    }

    public static Iterable<Link> getOutgoingTriggeredTransitionLinks(Node s) {
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof TriggeredTransition;
            }
        };
        return IterableExtensions.filter(s.getOutgoing(), (Functions.Function1)function1);
    }

    public static Iterable<TriggeredTransition> getOutgoingTriggeredTransitions(Node s) {
        Functions.Function1<Link, Transition> function1 = new Functions.Function1<Link, Transition>(){

            public Transition apply(Link it) {
                return it.getTransition();
            }
        };
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getOutgoingTriggeredTransitionLinks(s), (Functions.Function1)function1), TriggeredTransition.class);
    }

    public static List<Transition> getOutgoingTransitionsHierarchically(Node s) {
        Functions.Function1<Link, Transition> function1 = new Functions.Function1<Link, Transition>(){

            public Transition apply(Link it) {
                return it.getTransition();
            }
        };
        return ListExtensions.map(FsmGenExtensions.getOutgoingLinksHierarchically(s), (Functions.Function1)function1);
    }

    public static ArrayList<Link> getOutgoingLinksHierarchically(Node s) {
        ArrayList result = CollectionLiterals.newArrayList();
        Node current = s;
        while (current != null) {
            result.addAll(current.getOutgoing());
            Functions.Function1<Node, EList<Link>> function1 = new Functions.Function1<Node, EList<Link>>(){

                public EList<Link> apply(Node it) {
                    return it.getOutgoing();
                }
            };
            Iterables.addAll((Collection)result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(FsmGenExtensions.getTransitionPointNodes(current.getGraph()), (Functions.Function1)function1)));
            current = FsmGenExtensions.getParentState(current);
        }
        return result;
    }

    public static boolean isTopLevel(Graph g) {
        boolean bl = false;
        if (g != null) {
            EObject eObject = g.eContainer();
            bl = eObject instanceof GraphContainer;
        } else {
            bl = true;
        }
        return bl;
    }

    public static boolean isEmpty(Graph g) {
        return g == null || g.getNodes().isEmpty() && g.getLinks().isEmpty();
    }

    public static boolean isLeaf(Node n) {
        Graph graph = n.getSubgraph();
        return graph == null;
    }

    public static boolean isTopLevel(Node n) {
        return FsmGenExtensions.isTopLevel(n.getGraph());
    }

    public static Node getParentState(Node n) {
        Node node = null;
        boolean bl = FsmGenExtensions.isTopLevel(n);
        if (bl) {
            node = null;
        } else {
            EObject eObject = n.getGraph().eContainer();
            node = (Node)eObject;
        }
        return node;
    }

    public static Link getChoicepointDefaultBranch(Node n) {
        boolean bl;
        StateGraphNode stateGraphNode = n.getStateGraphNode();
        boolean bl2 = bl = !(stateGraphNode instanceof ChoicePoint);
        if (bl) {
            return null;
        }
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof ContinuationTransition;
            }
        };
        return (Link)IterableExtensions.head((Iterable)IterableExtensions.filter(n.getOutgoing(), (Functions.Function1)function1));
    }

    public static Node getParentState(Link l) {
        Node node = null;
        boolean bl = FsmGenExtensions.isTopLevel(l.getGraph());
        if (bl) {
            node = null;
        } else {
            EObject eObject = l.getGraph().eContainer();
            node = (Node)eObject;
        }
        return node;
    }

    public static boolean isHandler(Link l) {
        boolean bl = false;
        StateGraphNode sourceNode = l.getSource().getStateGraphNode();
        boolean bl2 = false;
        bl2 = sourceNode instanceof TransitionPoint ? ((TransitionPoint)sourceNode).isHandler() : false;
        bl = bl2;
        return bl;
    }

    public static List<DetailCode> getAllDetailCodes(Graph graph) {
        ArrayList detailCodes = CollectionLiterals.newArrayList();
        if (graph != null) {
            Functions.Function1<Link, Transition> function1 = new Functions.Function1<Link, Transition>(){

                public Transition apply(Link it) {
                    return it.getTransition();
                }
            };
            Iterator allTransitions = IteratorExtensions.map(FsmGenExtensions.getAllLinks(graph), (Functions.Function1)function1);
            Functions.Function1<Transition, DetailCode> function12 = new Functions.Function1<Transition, DetailCode>(){

                public DetailCode apply(Transition it) {
                    return it.getAction();
                }
            };
            List list = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allTransitions, (Functions.Function1)function12));
            Iterables.addAll((Collection)detailCodes, (Iterable)list);
            Functions.Function1<Node, StateGraphNode> function13 = new Functions.Function1<Node, StateGraphNode>(){

                public StateGraphNode apply(Node it) {
                    return it.getStateGraphNode();
                }
            };
            UnmodifiableIterator allStates = Iterators.filter((Iterator)IteratorExtensions.map(FsmGenExtensions.getAllStateNodes(graph), (Functions.Function1)function13), State.class);
            Functions.Function1<State, DetailCode> function14 = new Functions.Function1<State, DetailCode>(){

                public DetailCode apply(State it) {
                    return it.getEntryCode();
                }
            };
            List list2 = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allStates, (Functions.Function1)function14));
            Iterables.addAll((Collection)detailCodes, (Iterable)list2);
            Functions.Function1<State, DetailCode> function15 = new Functions.Function1<State, DetailCode>(){

                public DetailCode apply(State it) {
                    return it.getDoCode();
                }
            };
            List list3 = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allStates, (Functions.Function1)function15));
            Iterables.addAll((Collection)detailCodes, (Iterable)list3);
            Functions.Function1<State, DetailCode> function16 = new Functions.Function1<State, DetailCode>(){

                public DetailCode apply(State it) {
                    return it.getExitCode();
                }
            };
            List list4 = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allStates, (Functions.Function1)function16));
            Iterables.addAll((Collection)detailCodes, (Iterable)list4);
        }
        return detailCodes;
    }

    public static Link getLinkFor(GraphContainer gc, TransitionBase t) {
        Link link = null;
        Object object = null;
        object = t instanceof RefinedTransition ? ((RefinedTransition)t).getTarget() : t;
        final TransitionBase tr = object;
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition == tr;
            }
        };
        link = (Link)IteratorExtensions.findFirst(FsmGenExtensions.getAllLinks(gc.getGraph()), (Functions.Function1)function1);
        return link;
    }

    public static Iterable<State> getLeafStatesLast(List<State> states) {
        Iterable iterable = null;
        Functions.Function1<State, Boolean> function1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                StateGraph stateGraph = s.getSubgraph();
                return stateGraph == null;
            }
        };
        Iterable leaf = IterableExtensions.filter(states, (Functions.Function1)function1);
        Functions.Function1<State, Boolean> function12 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                StateGraph stateGraph = s.getSubgraph();
                return stateGraph != null;
            }
        };
        Iterable nonLeaf = IterableExtensions.filter(states, (Functions.Function1)function12);
        iterable = Iterables.concat((Iterable)nonLeaf, (Iterable)leaf);
        return iterable;
    }

    public static String getName(GraphItem l) {
        if (l instanceof Link) {
            return FsmGenExtensions._getName((Link)l);
        }
        if (l instanceof Node) {
            return FsmGenExtensions._getName((Node)l);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(l).toString());
    }
}

