//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.relations.options;

import org.eclipse.escet.common.app.framework.options.BooleanOption;
import org.eclipse.escet.common.app.framework.options.Options;

/** RFC-4180 compliance option. */
public class Rfc1480ComplianceOption extends BooleanOption {
    /** CLI option description text. */
    private static final String CLI_DESC_TEXT = "Whether to write fully compliant RFC-4180 files. "
            + "Disable the option (BOOL=no) to write only a newline character at the end of each DMM line. "
            + "Enable the option (BOOL=yes) to write both a carriage return and a newline character at the end of each "
            + "DMM line. Enabling the option is normally not necessary.";

    /** GUI option description text. */
    private static final String GUI_DESC_TEXT = "Whether to write fully compliant RFC-4180 files. "
            + "Disable the option to write only a newline character at the end of each DMM line. "
            + "Enable the option to write both a carriage return and a newline character at the end of each "
            + "DMM line. Enabling the option is normally not necessary.";

    /** Constructor of the {@link Rfc1480ComplianceOption} class. */
    public Rfc1480ComplianceOption() {
        super("RFC-4180 compliance", // Option name.
                CLI_DESC_TEXT + " [DEFAULT=no]",
                null, // Short option name.
                "rfc4180-compliant", // Long option name.
                "BOOL", // Command value.
                false, // Default value.
                true, // Shown in dialog.
                GUI_DESC_TEXT, // Dialog description.
                "Enable RFC-4180 compliance"); // Dialog checkbox label.
    }

    /**
     * Retrieve whether writing RFC-4180 compliant DMM files is enabled.
     *
     * @return Whether writing RFC-4180 compliant DMM files is enabled.
     */
    public static boolean isEnabled() {
        return Options.get(Rfc1480ComplianceOption.class);
    }
}
