/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.svg.selector.SvgSelectorOutlineStyle;

public class SvgInOutlineStyleOption
extends StringOption {
    private static final String DEFAULT = "red:green:1.5";
    private static final Map<String, Color> NAMED_COLORS = Map.ofEntries(Map.entry("black", Color.BLACK), Map.entry("blue", Color.BLUE), Map.entry("cyan", Color.CYAN), Map.entry("dark-gray", Color.DARK_GRAY), Map.entry("gray", Color.GRAY), Map.entry("green", Color.GREEN), Map.entry("light-gray", Color.LIGHT_GRAY), Map.entry("magenta", Color.MAGENTA), Map.entry("orange", Color.ORANGE), Map.entry("pink", Color.PINK), Map.entry("red", Color.RED), Map.entry("white", Color.WHITE), Map.entry("yellow", Color.YELLOW));
    private static final String DESCRIPTION = Strings.fmt((String)"The style to use for the outline of interactive elements of the SVG input mode. Specify \"off\" to not show any outline. Specify a hover color, click color and stroke width, separated by colons, to specify a specific style. For the colors, use: one of the named colors %s; or comma-separated red, green and blue components, each in range [0..255]. For the stroke width, specify the width in pixels as a positive floating point number.", (Object[])new Object[]{Strings.makeElementsChoiceText(NAMED_COLORS.keySet().stream().sorted().toList(), name -> "\"" + name + "\"")});

    public SvgInOutlineStyleOption() {
        super("SVG input outline style", DESCRIPTION + " [DEFAULT=\"red:green:1.5\"]", null, "svgin-outline-style", "STYLE", DEFAULT, false, true, DESCRIPTION, "Style:");
    }

    public static SvgSelectorOutlineStyle getStyle() {
        String text;
        String originalText = text = (String)Options.get(SvgInOutlineStyleOption.class);
        if ((text = text.strip().toLowerCase(Locale.US)).equals("off")) {
            return null;
        }
        String[] parts = text.split(":");
        if (parts.length != 3) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid SVG input outline style \"%s\": expected 3 values separated by colons, but got %d.", (Object[])new Object[]{originalText, parts.length}));
        }
        Color hoverColor = SvgInOutlineStyleOption.parseColor(parts[0]);
        Color clickColor = SvgInOutlineStyleOption.parseColor(parts[1]);
        float strokeWidth = SvgInOutlineStyleOption.parseWidth(parts[2]);
        return new SvgSelectorOutlineStyle(hoverColor, clickColor, strokeWidth);
    }

    private static Color parseColor(String text) {
        String originalText = text;
        Color color = NAMED_COLORS.get(text = text.strip().toLowerCase(Locale.US));
        if (color != null) {
            return color;
        }
        String[] parts = text.split(",");
        if (parts.length != 3) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid SVG input outline style color \"%s\": expected a known named color or 3 color components.", (Object[])new Object[]{originalText}));
        }
        int red = SvgInOutlineStyleOption.parseColorComponent(parts[0], "red");
        int green = SvgInOutlineStyleOption.parseColorComponent(parts[1], "green");
        int blue = SvgInOutlineStyleOption.parseColorComponent(parts[2], "blue");
        return new Color(red, green, blue);
    }

    private static int parseColorComponent(String text, String name) {
        int value;
        try {
            value = Integer.parseInt(text);
            if (value < 0 || value > 255) {
                throw new NumberFormatException("Number outside of the [0..255] range.");
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid SVG input outline style color %s component \"%s\": invalid number.", (Object[])new Object[]{name, text}), (Throwable)e);
        }
        return value;
    }

    private static float parseWidth(String text) {
        float width;
        try {
            width = Float.parseFloat(text.strip());
            if (Float.isNaN(width)) {
                throw new NumberFormatException("Width is not a number.");
            }
            if (Float.isInfinite(width)) {
                throw new NumberFormatException("Width is infinite.");
            }
            if (width <= 0.0f) {
                throw new NumberFormatException("Width is not positive.");
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid SVG input outline style width \"%s\".", (Object[])new Object[]{text}), (Throwable)e);
        }
        return width;
    }
}

