/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.win32;

import com.sun.jna.platform.win32.Crypt32Util;
import java.io.IOException;
import java.security.SecureRandom;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.auth.nls.SecAuthMessages;
import org.eclipse.equinox.internal.security.storage.Base64;
import org.eclipse.equinox.internal.security.win32.WinCryptoMessages;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;

public class WindowsPasswordProvider
extends PasswordProvider {
    private static final String WIN_PROVIDER_NODE = "/org.eclipse.equinox.secure.storage/windows64";
    private static final String PASSWORD_KEY = "encryptedPassword";
    private static final int PASSWORD_LENGTH = 250;

    private static byte[] windecrypt(byte[] encryptedText) {
        return Crypt32Util.cryptUnprotectData((byte[])encryptedText);
    }

    private static byte[] winencrypt(byte[] clearText) {
        return Crypt32Util.cryptProtectData((byte[])clearText, null, (int)0, (String)"Equinox", null);
    }

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        byte[] encryptedPassword = (passwordType & 1) == 0 ? this.getEncryptedPassword(container) : null;
        if (encryptedPassword != null) {
            byte[] decryptedPassword = WindowsPasswordProvider.windecrypt(encryptedPassword);
            if (decryptedPassword != null) {
                String password = new String(decryptedPassword);
                return new PBEKeySpec(password.toCharArray());
            }
            StorageException e = new StorageException(2, WinCryptoMessages.decryptPasswordFailed);
            AuthPlugin.getDefault().logError(WinCryptoMessages.decryptPasswordFailed, (Throwable)e);
            return null;
        }
        AuthPlugin.getDefault().logMessage(WinCryptoMessages.newPasswordGenerated);
        byte[] rawPassword = new byte[250];
        new SecureRandom().nextBytes(rawPassword);
        String password = Base64.encode((byte[])rawPassword);
        if (this.savePassword(password, container)) {
            return new PBEKeySpec(password.toCharArray());
        }
        return null;
    }

    private byte[] getEncryptedPassword(IPreferencesContainer container) {
        ISecurePreferences node = container.getPreferences().node(WIN_PROVIDER_NODE);
        try {
            String passwordHint = node.get(PASSWORD_KEY, null);
            if (passwordHint != null) {
                return Base64.decode((String)passwordHint);
            }
        }
        catch (StorageException e) {
            AuthPlugin.getDefault().logError(WinCryptoMessages.decryptPasswordFailed, (Throwable)e);
        }
        return null;
    }

    private boolean savePassword(String password, IPreferencesContainer container) {
        byte[] data = WindowsPasswordProvider.winencrypt(password.getBytes());
        if (data == null) {
            StorageException e = new StorageException(2, WinCryptoMessages.encryptPasswordFailed);
            AuthPlugin.getDefault().logError(WinCryptoMessages.encryptPasswordFailed, (Throwable)e);
            return false;
        }
        String encodedEncryptyedPassword = Base64.encode((byte[])data);
        ISecurePreferences node = container.getPreferences().node(WIN_PROVIDER_NODE);
        try {
            node.put(PASSWORD_KEY, encodedEncryptyedPassword, false);
        }
        catch (StorageException e) {
            AuthPlugin.getDefault().logError(SecAuthMessages.errorOnSave, (Throwable)e);
            return false;
        }
        try {
            node.flush();
        }
        catch (IOException e) {
            AuthPlugin.getDefault().logError(SecAuthMessages.errorOnSave, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean retryOnError(Exception e, IPreferencesContainer container) {
        return false;
    }
}

