/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.supportability.ConsoleInputHandler;
import org.eclipse.equinox.console.telnet.Callback;
import org.eclipse.equinox.console.telnet.NegotiationFinishedCallback;
import org.eclipse.equinox.console.telnet.TelnetInputHandler;
import org.eclipse.equinox.console.telnet.TelnetOutputStream;

public class TelnetConnection
extends Thread {
    private Socket socket;
    private CommandProcessor processor;
    private boolean isTelnetNegotiationFinished = false;
    private Callback callback;
    private static final long WAIT_INTERVAL = 1000L;
    private static final long NEGOTIATION_TIMEOUT = 60000L;

    public TelnetConnection(Socket socket, CommandProcessor processor) {
        this.socket = socket;
        this.processor = processor;
        this.callback = new NegotiationFinishedCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block19: {
            try {
                ConsoleInputStream in = new ConsoleInputStream();
                TelnetOutputStream out = new TelnetOutputStream(this.socket.getOutputStream());
                out.autoSend();
                TelnetInputHandler telnetInputHandler = new TelnetInputHandler(this.socket.getInputStream(), in, out, this.callback);
                telnetInputHandler.start();
                long start = System.currentTimeMillis();
                while (!this.isTelnetNegotiationFinished && System.currentTimeMillis() - start < 60000L) {
                    TelnetConnection telnetConnection = this;
                    synchronized (telnetConnection) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                PrintStream output = new PrintStream(out);
                ConsoleInputStream inp = new ConsoleInputStream();
                ConsoleInputHandler consoleInputHandler = new ConsoleInputHandler(in, inp, out);
                consoleInputHandler.getScanner().setBackspace(telnetInputHandler.getScanner().getBackspace());
                consoleInputHandler.getScanner().setDel(telnetInputHandler.getScanner().getDel());
                consoleInputHandler.getScanner().setCurrentEscapesToKey(telnetInputHandler.getScanner().getCurrentEscapesToKey());
                consoleInputHandler.getScanner().setEscapes(telnetInputHandler.getScanner().getEscapes());
                consoleInputHandler.start();
                CommandSession session = this.processor.createSession((InputStream)inp, output, output);
                try {
                    try {
                        session.execute((CharSequence)"gosh --login --noshutdown");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        session.close();
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                session.close();
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void telnetNegotiationFinished() {
        this.isTelnetNegotiationFinished = true;
        this.notify();
    }
}

