/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.jmx.internal;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.jmx.common.ContributionNotificationEvent;
import org.eclipse.equinox.jmx.server.Contribution;
import org.eclipse.equinox.jmx.server.ContributionProvider;
import org.eclipse.osgi.jmx.internal.Activator;
import org.eclipse.osgi.jmx.internal.BundleContribution;
import org.eclipse.osgi.jmx.internal.BundleContributionMessages;
import org.eclipse.osgi.jmx.internal.BundleUtils;
import org.eclipse.osgi.jmx.internal.ServiceContribution;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleContributionProvider
extends ContributionProvider
implements BundleListener {
    private static final String BUNDLE_IMG_PATH = "icons/bundles/bundle.gif";
    private static Set serverPluginDependencies;
    private ServiceReference serviceReference;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BundleContributionProvider() {
        this(null);
    }

    public BundleContributionProvider(ServiceReference serviceReference) {
        this.serviceReference = serviceReference;
        if (serverPluginDependencies == null) {
            try {
                serverPluginDependencies = BundleUtils.computeDependencies(Activator.getBundle(), Activator.getBundleContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public static boolean isPluginDependency(Bundle bundle) {
        Assert.isNotNull((Object)serverPluginDependencies);
        Iterator iter = serverPluginDependencies.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (bundle.getSymbolicName() == null || !bundle.getSymbolicName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean providesType(Object obj) {
        return obj instanceof ServiceReference;
    }

    protected boolean contributesType(Object obj) {
        return obj instanceof Bundle;
    }

    protected ContributionProvider createProvider(Object obj) {
        return this.providesType(obj) ? new BundleContributionProvider((ServiceReference)obj) : null;
    }

    protected Contribution createContribution(Object obj) throws MalformedObjectNameException, NullPointerException {
        if (this.contributesType(obj)) {
            if (this.serviceReference != null) {
                return new BundleContribution((Bundle)obj, this.serviceReference);
            }
            return new BundleContribution((Bundle)obj);
        }
        return null;
    }

    public Object[] getChildren() {
        TreeSet<Bundle> result = null;
        if (this.serviceReference != null) {
            result = new TreeSet<Bundle>();
            Bundle[] usingBundles = this.serviceReference.getUsingBundles();
            if (usingBundles != null) {
                int i = 0;
                while (i < usingBundles.length) {
                    result.add(usingBundles[i]);
                    ++i;
                }
            }
            result.add(this.serviceReference.getBundle());
        }
        return result == null ? Activator.getBundleContext().getBundles() : result.toArray();
    }

    public String getName() {
        return this.serviceReference == null ? BundleContributionMessages.bundle_contribution_name : NLS.bind((String)BundleContributionMessages.service_bundle_contribution_name, (Object)ServiceContribution.getServiceReferenceName(this.serviceReference));
    }

    public Set getProperties() {
        return null;
    }

    protected URL getImageLocation() {
        return FileLocator.find((Bundle)Activator.getBundle(), (IPath)new Path(BUNDLE_IMG_PATH), null);
    }

    public Object getAttribute(String arg0) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList getAttributes(String[] arg0) {
        return null;
    }

    public AttributeList setAttributes(AttributeList arg0) {
        return null;
    }

    public MBeanInfo getMBeanInfo(Object delegate) {
        return new MBeanInfo(((Object)((Object)this)).getClass().getName(), null, null, null, new MBeanOperationInfo[]{BundleContributionProvider.createInstallOperation()}, null);
    }

    public Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        if (operationName.equals("install") && args.length == 1 && argTypes.length == 1 && args[0] instanceof String) {
            String installUrl = (String)args[0];
            try {
                Bundle bundle = Activator.getBundleContext().installBundle(installUrl);
                BundleContributionProvider.refreshPackages(new Bundle[]{bundle});
            }
            catch (BundleException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                super.contributionStateChanged(new ContributionNotificationEvent("contribution.added"));
                return;
            }
        }
    }

    public static void refreshPackages(Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        BundleContext context = Activator.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference packageAdminRef = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        packageAdmin.refreshPackages(bundles);
        context.ungetService(packageAdminRef);
    }

    private static MBeanOperationInfo createInstallOperation() {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("bundleURLAsString", clazz.getName(), BundleContributionMessages.bundle_url_desc);
        return new MBeanOperationInfo("install", BundleContributionMessages.install_operation_desc, mBeanParameterInfoArray, Void.TYPE.getName(), 0);
    }
}

